# set on input: $CHR, $OUT_PREFIX, $CORES

set -euo pipefail

chmod +x normPhaseRegions

INPUTS_DIR=/mnt/project/lohdata/ploh/WES_CNVs/region_phasing/inputs
RESOURCES_DIR=/mnt/project/lohdata/resources

N_NBR=300
PBWT_BAND_WIDTH=20

TMP_DIR=$HOME/tmp
mkdir -p $TMP_DIR

ls /mnt/project/lohdata/ploh/WES_CNVs/WES_read_counts/results/WES_{15K,454K}_batch*/*.regions.chr$CHR.bin.gz > $TMP_DIR/WES_read_counts_bin_gz_list.txt

./normPhaseRegions \
    chr$CHR \
    <(zcat /mnt/project/lohdata/ploh/WES_CNVs/WES_read_counts/inputs/WES_{15K,454K}.ID_cram.txt.gz) \
    $TMP_DIR/WES_read_counts_bin_gz_list.txt \
    /mnt/project/lohdata/ploh/WES_CNVs/noise_neighbors/results/ID_scale_neighbors_trimmed.WES_470K.40709.txt.gz \
    $RESOURCES_DIR/bim_with_cM/chr$CHR.bim \
    $RESOURCES_DIR/mosaic500K_phasing/chr$CHR.snps.txt.gz \
    $INPUTS_DIR/chr$CHR.UKBsites.hg38.ucsc_bed \
    "/mnt/project/Bulk/Imputation/UKB imputation from genotype/ukb22828_c1_b0_v3.sample" \
    $RESOURCES_DIR/mosaic500K_phasing/mosaic500K_phasing.chr$CHR.hap64.bin \
    $INPUTS_DIR/trios_indep_EUR.40709.txt \
    $N_NBR \
    $PBWT_BAND_WIDTH \
    $CORES \
    $OUT_PREFIX

rm $TMP_DIR/WES_read_counts_bin_gz_list.txt

plink2 --import-dosage $OUT_PREFIX.dosage.txt noheader \
    --fam $OUT_PREFIX.fam \
    --map $OUT_PREFIX.map \
    --export bgen-1.2 bits=8 \
    --out $OUT_PREFIX

plink2 --import-dosage $OUT_PREFIX.nbrMean.dosage.txt noheader \
    --fam $OUT_PREFIX.fam \
    --map $OUT_PREFIX.nbrMean.map \
    --export bgen-1.2 bits=8 \
    --out $OUT_PREFIX.nbrMean

rm $OUT_PREFIX.{dosage.txt,nbrMean.dosage.txt,fam,map,nbrMean.map,log,nbrMean.log}

sudo apt-get install pigz

pigz $OUT_PREFIX.hapCN.txt
