# set on input: $SAMPLE_SET, $CORES

#CORES=8
#SAMPLE_SET=0

set -euo pipefail

chmod +x normalizeReadCounts
chmod +x computeSDscales

N_NBR=300

for CHR in {1..22}
do
    ls /mnt/project/lohdata/ploh/WES_CNVs/WES_read_counts/results/WES_{454K,15K}_batch*/*.100bp.chr$CHR.bin.gz > WES_read_counts_bin_gz_list.txt

    ./normalizeReadCounts \
    	/mnt/project/lohdata/ploh/WES_CNVs/normalized_read_counts/inputs/IDs_40709.set$SAMPLE_SET.txt \
    	/mnt/project/lohdata/ploh/WES_CNVs/noise_neighbors/results/ID_scale_neighbors_trimmed.WES_470K.40709.txt.gz \
    	WES_read_counts_bin_gz_list.txt \
    	$N_NBR \
    	$CORES \
    	baselineScales.chr$CHR.set$SAMPLE_SET.bin \
    	RCs.chr$CHR.set$SAMPLE_SET.bin

    rm WES_read_counts_bin_gz_list.txt
done

./computeSDscales \
    baselineScales.chr%d.set$SAMPLE_SET.bin \
    RCs.chr%d.set$SAMPLE_SET.bin \
    /mnt/project/lohdata/ploh/WES_CNVs/normalized_read_counts/inputs/noCommonSVregions.highCov1000_sdNormRCs_50K_150K.txt.gz \
    $CORES \
    ID_40709.stdScale.cInvs.set$SAMPLE_SET.txt.gz

sudo apt-get install pigz

for CHR in {1..22}
do
    pigz baselineScales.chr$CHR.set$SAMPLE_SET.bin
    rm RCs.chr$CHR.set$SAMPLE_SET.bin
done
