# CORES set on input

set -euo pipefail

BP_RES=1000
MIN_DEPTH=5
MAX_DEPTH=100
TOP_QUANTILE=0.9

KEEP=15K

chmod +x computeReadCountSketches

./computeReadCountSketches $BP_RES $MIN_DEPTH $MAX_DEPTH $TOP_QUANTILE \
    /mnt/project/lohdata/ploh/WES_CNVs/noise_neighbors/inputs/qc_regions.mean_150K_count_gt_5.noheader.mean_150K.txt \
    header.txt.gz \
    data.txt.gz

cat {header,data}.txt.gz > ID_scale_zdepths.${BP_RES}bp.meanDP_${MIN_DEPTH}_$MAX_DEPTH.top$TOP_QUANTILE.$KEEP.txt.gz
rm {header,data}.txt.gz


Z_MAX=3
N_NBR=300
BATCH=0
NBATCH=1

chmod +x findNeighborsEUR

./findNeighborsEUR \
    $BATCH \
    $NBATCH \
    $Z_MAX \
    $N_NBR \
    ID_scale_zdepths.${BP_RES}bp.meanDP_${MIN_DEPTH}_$MAX_DEPTH.top$TOP_QUANTILE.$KEEP.txt.gz \
    $CORES \
    ID_scale_neighbors.$KEEP.batch$[BATCH+1].txt.gz \
