#!/bin/bash

if [ "$1" != "" ]; then ANALYSIS_DIR="$1/"; else ANALYSIS_DIR=""; fi

set -euo pipefail

THREADS=6

INPUT_DIR=${ANALYSIS_DIR}input # directory containing inputs
OUTPUT_DIR=${ANALYSIS_DIR}output # directory in which to store outputs and temporary files

ARRAY_DATA_DIR=$OUTPUT_DIR/array_data # subdirectory in which processed SNP-array data is stored
IBD_DIR=$OUTPUT_DIR/IBD # subdirectory in which haplotype-sharing (IBD) data is stored
mkdir -p $IBD_DIR

for CHR in {1..22} # NOTE: parallelize this loop across jobs if using a cluster/cloud
do
    BED_BIM_FAM_PREFIX=$INPUT_DIR/chr$CHR # input plink files: .{bed,bim,fam}
    HAPS_SAMPLE_PREFIX=$INPUT_DIR/chr$CHR.phased # input phased haplotypes: .{haps.gz,sample}
    LRR_THETA_GENO_FILE=$ARRAY_DATA_DIR/lrr_theta_confgeno.chr$CHR.bin # previously generated by merge_lrr_theta_geno
    IBD_PREFIX=$IBD_DIR/chr$CHR.ibd # output to be generated

    ./bin/find_IBD \
	$BED_BIM_FAM_PREFIX \
	$HAPS_SAMPLE_PREFIX \
	$LRR_THETA_GENO_FILE \
	$THREADS \
	$IBD_PREFIX.bin \
	| tee $IBD_PREFIX.log
done
