#!/bin/bash

if [ "$1" != "" ]; then ANALYSIS_DIR="$1/"; else ANALYSIS_DIR=""; fi

set -euo pipefail

INPUT_DIR=${ANALYSIS_DIR}input # directory containing inputs
OUTPUT_DIR=${ANALYSIS_DIR}output # directory in which to store outputs and temporary files

ARRAY_DATA_DIR=$OUTPUT_DIR/array_data # subdirectory in which processed SNP-array data is stored

for CHR in {1..22} # NOTE: parallelize this loop across jobs if using a cluster/cloud
do
    BED_BIM_FAM_PREFIX=$INPUT_DIR/chr$CHR # input plink files: .{bed,bim,fam}
    THETA_FILE=$INPUT_DIR/chr$CHR.theta.txt.gz # input theta file
    LRR_DENOISED_FILE=$ARRAY_DATA_DIR/LRR_denoised.chr$CHR.bin # previously generated by denoise_lrr
    LRR_THETA_GENO_PREFIX=$ARRAY_DATA_DIR/lrr_theta_confgeno.chr$CHR # output to be generated

    ./bin/merge_lrr_theta_geno \
	$BED_BIM_FAM_PREFIX \
	$LRR_DENOISED_FILE \
	$THETA_FILE \
	$LRR_THETA_GENO_PREFIX.bin \
	| tee $LRR_THETA_GENO_PREFIX.log

    rm $LRR_DENOISED_FILE
done
