#ifndef VERSIONHEADER_HPP
#define VERSIONHEADER_HPP

#include <cstdio>
#include <cstdlib>
#include <cstring>

void printVersion(void) {
  printf("+----------------------------+\n");
  printf("| HI-CNV v1.0 (Jul 14, 2022) |\n");
  printf("+----------------------------+\n");
  printf("\n");
  fflush(stdout);
}

void printCmd(int argc, char *argv[]) {
  printf("Command line:\n");
  printf("\n");
  for (int i = 0; i < argc; i++) {
    if (i) printf("    ");
    printf("%s", argv[i]);
    if (i != argc-1) printf(" \\");
    printf("\n");
  }
  printf("\n");
  fflush(stdout);
}

char *checkInputFileExt(char *argv[], int a, const char *ext) {
  if (strlen(argv[a]) < strlen(ext) || strcmp(argv[a]+strlen(argv[a])-strlen(ext), ext) != 0) {
    printf("ERROR: arg%d = %s does not end with %s\n", a, argv[a], ext);
    exit(1);
  }
  return argv[a];
}

#endif
