#!/bin/bash -x

set -eo pipefail

BOOST_INSTALL_DIR=/home/pl88/boost_1_58_0/install
MKLROOT=/n/groups/price/poru/external_software/intel_mkl_2019u4/mkl # only needed for denoise_lrr


if [ "$1" == "static" ]; then
    ### only needed for static linking (unnecessary in a local install)
    ZLIB_STATIC_DIR=/n/groups/price/poru/external_software/zlib/zlib-1.2.11
    LIBSTDCXX_STATIC_DIR=/n/groups/price/poru/external_software/libstdc++/usr/lib/gcc/x86_64-redhat-linux/4.8.5/
fi


for OPT_FLAG in -O3 -g
do
    TARGET_SUFFIX=""
    if [ "$OPT_FLAG" == "-g" ]; then TARGET_SUFFIX="_debug"; fi

    ### compile all other binaries (only need Boost)
    for TARGET in check_inputs merge_lrr_theta_geno call_CNVs_prelim compute_ref_clusters predict_clusters find_IBD make_imp_masks call_CNVs interpolate_bim
    do
	LBOOST=-lboost_iostreams
	if [ $TARGET == "interpolate_bim" ]; then LBOOST="$LBOOST -lboost_program_options"; fi

	if [ "$1" != "static" ]; then
	    g++ $OPT_FLAG -fopenmp -Wall \
		$TARGET.cpp -o ../bin/$TARGET${TARGET_SUFFIX} \
		-I./utils \
		-I${BOOST_INSTALL_DIR}/include \
		-L${BOOST_INSTALL_DIR}/lib -Wl,-rpath,${BOOST_INSTALL_DIR}/lib \
		${LBOOST} -lz
	else
	    g++ $OPT_FLAG -fopenmp -Wall -static-libgcc -static-libstdc++ \
		$TARGET.cpp -o ../bin/$TARGET${TARGET_SUFFIX} \
		-I./utils \
		-I${BOOST_INSTALL_DIR}/include \
		-L${LIBSTDCXX_STATIC_DIR} \
		-L${ZLIB_STATIC_DIR} \
		-L${BOOST_INSTALL_DIR}/lib \
		-Wl,-Bstatic ${LBOOST} -lz
	fi	    
    done

    ### compile denoise_lrr (needs MKL and Boost)
    if [ "$1" != "static" ]; then
	g++ -DMKL_ILP64 -m64 $OPT_FLAG -fopenmp -Wall \
	    denoise_lrr.cpp -o ../bin/denoise_lrr${TARGET_SUFFIX} \
	    -I./utils \
	    -I${BOOST_INSTALL_DIR}/include \
	    -I${MKLROOT}/include \
	    -L${BOOST_INSTALL_DIR}/lib -Wl,-rpath,${BOOST_INSTALL_DIR}/lib \
	    -L${MKLROOT}/lib/intel64 -Wl,-rpath,${MKLROOT}/lib/intel64 -Wl,--no-as-needed \
	    -lmkl_intel_ilp64 -lmkl_gnu_thread -lmkl_core \
	    -lgomp -lboost_iostreams -lz \
	    -lpthread -lm -ldl
    else
	g++ -DMKL_ILP64 -m64 $OPT_FLAG -fopenmp -Wall -static-libgcc -static-libstdc++ \
	    denoise_lrr.cpp -o ../bin/denoise_lrr${TARGET_SUFFIX} \
	    -I./utils \
	    -I${BOOST_INSTALL_DIR}/include \
	    -I${MKLROOT}/include \
	    -L${LIBSTDCXX_STATIC_DIR} \
	    -L${ZLIB_STATIC_DIR} \
	    -L${BOOST_INSTALL_DIR}/lib \
	    -Wl,--start-group ${MKLROOT}/lib/intel64/libmkl_intel_ilp64.a ${MKLROOT}/lib/intel64/libmkl_gnu_thread.a ${MKLROOT}/lib/intel64/libmkl_core.a -Wl,--end-group \
	    -Wl,-Bstatic -lgomp -lboost_iostreams -lz \
	    -Wl,-Bdynamic -lpthread -lm -ldl
    fi

done
