#!/bin/bash

if [ "$1" != "" ]; then ANALYSIS_DIR="$1/"; else ANALYSIS_DIR=""; fi

set -euo pipefail

THREADS=6

INPUT_DIR=${ANALYSIS_DIR}input # directory containing inputs
OUTPUT_DIR=${ANALYSIS_DIR}output # directory in which to store outputs and temporary files

ARRAY_DATA_DIR=$OUTPUT_DIR/array_data # subdirectory in which processed SNP-array data is stored
SNP_CLUSTER_DIR=$OUTPUT_DIR/snp_clusters # subdirectory in which genotype cluster data is stored
IBD_DIR=$OUTPUT_DIR/IBD # subdirectory in which haplotype-sharing (IBD) data is stored
NEARBY_IMP_MASK_DIR=$OUTPUT_DIR/near_imputed_masks # subdirectory in which genotype masks are stored
CNV_CALL_DIR=$OUTPUT_DIR/HI-CNV_calls # subdirectory in which to store HI-CNV calls
mkdir -p $CNV_CALL_DIR

LIKELIHOOD_CLIP_THRESH=3e-3 # parameter bounding the minimum/maximum Bayes factor a single probe measurement in a single individual can contribute to a CNV call

for CHR in {1..22} # NOTE: parallelize these loops across jobs if using a cluster/cloud
do
    for IBD_WEIGHT_PARAM in 0 5 10 25 50 100 # IBD weighting parameter used for haplotype-sharing model (roughly corresponding to TMRCA)
    do
	LRR_STD_SCALE_FILE=$ARRAY_DATA_DIR/LRR_denoised.std_scale.txt # previously generated by denoise_lrr
	BIM_FILE=$INPUT_DIR/chr$CHR.bim # input plink .bim file
	LRR_THETA_GENO_FILE=$ARRAY_DATA_DIR/lrr_theta_confgeno.chr$CHR.bin # previously generated by merge_lrr_theta_geno
	PRED_CLUSTER_PREFIX=$SNP_CLUSTER_DIR/pred_clusters.chr$CHR # previously generated by predict_clusters
	IBD_FILE=$IBD_DIR/chr$CHR.ibd.bin # previously generated by find_IBD
	NEARBY_IMP_MASK_FILE=$NEARBY_IMP_MASK_DIR/imp_masks.chr$CHR.bin # previously generated by make_imp_masks
	OUTPUT_PREFIX=$CNV_CALL_DIR/CNVs.chr$CHR.ibd$IBD_WEIGHT_PARAM # output to be generated

	./bin/call_CNVs \
	    $LRR_STD_SCALE_FILE \
	    $BIM_FILE \
	    $LRR_THETA_GENO_FILE \
	    $PRED_CLUSTER_PREFIX \
	    $LIKELIHOOD_CLIP_THRESH \
	    $IBD_FILE \
	    $IBD_WEIGHT_PARAM \
	    $NEARBY_IMP_MASK_FILE \
	    $THREADS \
	    $OUTPUT_PREFIX.txt.gz \
	    | tee $OUTPUT_PREFIX.log
    done
done
