#!/bin/bash

if [ "$1" != "" ]; then ANALYSIS_DIR="$1/"; else ANALYSIS_DIR=""; fi

set -euo pipefail

THREADS=6
NUM_PCS=50 # number of LRR principal components to use for denoising

INPUT_DIR=${ANALYSIS_DIR}input # directory containing inputs
OUTPUT_DIR=${ANALYSIS_DIR}output # directory in which to store outputs and temporary files

ARRAY_DATA_DIR=$OUTPUT_DIR/array_data # subdirectory in which processed SNP-array data is stored
mkdir -p $ARRAY_DATA_DIR

SAMPLE_INFO_FILE=$INPUT_DIR/sample_info.txt # input sample info file
LRR_FORMAT_STRING=$INPUT_DIR/chr%d.LRR.txt.gz # input LRR files
LRR_DENOISED_PREFIX=$ARRAY_DATA_DIR/LRR_denoised # output prefix: .chr{1..22}.bin,.std_scale.txt

./bin/denoise_lrr \
    $SAMPLE_INFO_FILE \
    $LRR_FORMAT_STRING \
    $NUM_PCS \
    $THREADS \
    $LRR_DENOISED_PREFIX \
    | tee $LRR_DENOISED_PREFIX.log
