/*
* The Broad Institute
* SOFTWARE COPYRIGHT NOTICE AGREEMENT
* This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
* of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
* (the "License"); you may not use this file except in compliance with
*  the License.  You may obtain a copy of the License at
*
*    http://www.opensource.org/licenses/gpl-2.0.php
*
* This software is supplied without any warranty or guaranteed support
* whatsoever. Neither the Broad Institute nor MIT can be responsible for its
* use, misuse, or functionality.
*/

package org.broad.igv.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;


/**
*
* @author eflakes
*/

final public class ZipArchiveWrapper {
   
    private static Logger logger = Logger.getLogger(Utilities.class);
    private File zipFile;
    private URL zipUrl;

    public ZipArchiveWrapper(File zipFile) throws FileNotFoundException, IOException {

        if(zipFile == null) {
            throw new FileNotFoundException("Zip file was null!");
        }
        this.zipFile = zipFile;
        zipUrl = zipFile.toURI().toURL();
    }

    public ZipIterator iterator() throws IOException {
        ZipIterator iterator = 
            new ZipIterator(new ZipInputStream(zipUrl.openStream()));
        return iterator;
    }

    public int getEntryCount() throws IOException {
        ZipIterator iterator = 
            new ZipIterator(new ZipInputStream(zipUrl.openStream()));
        int count = 0;
        while(iterator.hasNext()) {
            count++;
        }
        return count;
    }
    /*
     * Iterator
     */
    /*
    public class ZipIterator implements Iterator {

        public boolean hasNext() {
            if(zipInputStream == null) {
                return false;
            }
            else {
                try {
                    return zipInputStream.available() == 1 ? true:false;
                } catch(IOException e) {
                    logger.error("Zip entry error!", e);
                    return false;
                }
            }
        }

        public ZipEntry next() {

            ZipEntry entry = null;
            try {     
                entry = zipInputStream.getNextEntry();                         
            }
            catch(IOException e) {
                logger.error("Zip entry error!", e);
            }
            return entry;           
        }
*/
    

    public class ZipIterator implements Iterator {

        private boolean firstTime = true;
        private ZipEntry zipEntry = null;
        ZipInputStream zipInputStream;

        public ZipIterator(ZipInputStream zipInputStream) {
            this.zipInputStream = zipInputStream;
        }

        public boolean hasNext() {

            if(zipInputStream == null) {
                return false;
            }
            else 
            {
                try {
                    if(firstTime) {
                        firstTime = false;
                        zipEntry = zipInputStream.getNextEntry(); 
                        if(zipEntry == null) {
                            return false; // must have read the last one already
                        }
                    }
                    else {
                        if(zipEntry == null) {
                            return false; // must have read the last one already
                        }
                        else {
                            zipEntry = zipInputStream.getNextEntry(); 
                            if(zipEntry == null) {
                                return false; // No more entries
                            }
                        }
                    }
                }
                catch(IOException e) {
                    logger.error("Zip entry error!", e);
                }
            }
            return true;
        }

        public ZipEntry next() {
            return zipEntry;           
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public ZipInputStream getZipInputStream() {
            return zipInputStream;
        }

        public void close() {
            try {
                if(zipInputStream != null) {
                    zipInputStream.close();
                }
            } 
            catch (IOException ex) {
                logger.warn("Error closing zip file "+zipFile.getAbsolutePath(), ex);
            }
        }    
    }        
    
}
