/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */

/*
 * AddCopyright.java
 *
 * Created on October 9, 2007, 1:39 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package org.broad.igv.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;

/**
 *
 * @author jrobinso
 */
public class UpdateCopyright {

    private static String copyrightFile = "src/copyright.txt";
    private static String srcDir = "src";

    public static void addCopyright(File dirOrFile) throws FileNotFoundException, IOException {


        if (dirOrFile.isDirectory() && !dirOrFile.getName().equals(".svn")) {
            File outputDir = new File("tmp/" + dirOrFile.getPath());
            if (!outputDir.exists()) {
                outputDir.mkdir();
            }
            for (File f : dirOrFile.listFiles()) {
                if (f.isDirectory() || !hasCopyright(f)) {
                    addCopyright(f);
                }
            }
        } else {
            if (dirOrFile.getName().endsWith("java")) {
                addCopyrightToFile(dirOrFile);
            }
        }
    }

    /**
     * Add a copyright notice to the beginning of the src file.
     */
    private static void addCopyrightToFile(File srcFile) throws FileNotFoundException, IOException {


        StringWriter sw = new StringWriter(20000);
        PrintWriter pw = new PrintWriter(sw);

        BufferedReader srcReader = new BufferedReader(new FileReader(srcFile));
        BufferedReader copyrightReader = new BufferedReader(new FileReader(copyrightFile));

        // Write out the copyright to the new file
        String nextLine = "";
        while ((nextLine = copyrightReader.readLine()) != null) {
            pw.println(nextLine);
        }
        pw.println();
        copyrightReader.close();
        // Write out src contents starting with #package definition
        while ((nextLine = srcReader.readLine()) != null) {
            pw.println(nextLine);
        }
        srcReader.close();

        BufferedReader reader = new BufferedReader(new StringReader(sw.getBuffer().toString()));
        pw = new PrintWriter(new BufferedWriter(new FileWriter(srcFile)));
        while ((nextLine = reader.readLine()) != null) {
            pw.println(nextLine);
        }

        pw.close();
    }

    /**
     * Scan the first 200 lines of the source file searching for the string "copyright"
     * @param file
     * @return
     */
    private static boolean hasCopyright(File srcFile) throws FileNotFoundException, IOException {

        BufferedReader srcReader = null;

        srcReader = new BufferedReader(new FileReader(srcFile));

        String nextLine = null;
        int lineCount = 0;
        while ((nextLine = srcReader.readLine()) != null && lineCount < 200) {
            if (nextLine.toLowerCase().contains("copyright")) {
                return true;
            }
            lineCount++;
        }
        return false;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {

        File dir = new File(srcDir);
        addCopyright(dir);

    }
}
