/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.util;

//~--- JDK imports ------------------------------------------------------------
import java.io.*;

/**
 * Collection of static methods useful for parsing ascii files
 * @author jrobinso
 */
public class ParserUtilities {

    /**
     * Split the string into tokesn separated by the given delimiter.  Profiling has
     * revealed that the standard string.split() method typically takes > 1/2
     * the total time when used for parsing ascii files.
     *
     * @param aString  the string to split
     * @param buffer
     * @param delim
     * @return
     */
    public static int split(String aString, String[] buffer, char delim) {

        int nTokens = 0;
        int start = 0;
        int end = aString.indexOf(delim);
        while (end > 0)
        {
            buffer[nTokens++] = aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(delim, start);
            if (nTokens == buffer.length)
            {
                System.out.println("Token buffer overflow: " + aString);
            }
        }

        buffer[nTokens++] = aString.substring(start);
        return nTokens;
    }

    /**
     * Method description
     *
     *
     * @param str
     * @param ifile
     * @param ofile
     *
     * @throws IOException
     */
    public static void replaceString(String str, String rplString, File ifile, File ofile) throws IOException {

        PrintWriter pw = null;
        BufferedReader br = null;

        try
        {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(ofile)));
            br = new BufferedReader(new FileReader(ifile));
            String nextLine = null;
            while ((nextLine = br.readLine()) != null)
            {
                if (!nextLine.startsWith("##"))
                {
                    pw.println(nextLine.replace(str, rplString));
                }
            }
        } finally
        {
            pw.close();
            br.close();
        }
    }

    /**
     * Method description
     *
     *
     * @param str
     * @param ifile
     * @param ofile
     *
     * @throws IOException
     */
    public static void dropLinesContaining(String str, File ifile, File ofile) throws IOException {

        PrintWriter pw = null;
        BufferedReader br = null;

        try
        {
            pw = new PrintWriter(new BufferedWriter(new FileWriter(ofile)));
            br = new BufferedReader(new FileReader(ifile));
            String nextLine = null;
            while ((nextLine = br.readLine()) != null)
            {
                if (!nextLine.contains(str))
                {
                    pw.println(nextLine);
                }
            }
        } finally
        {
            pw.close();
            br.close();
        }
    }

    public static void main(String[] args) throws IOException {
        File ifile = new File("/Users/jrobinso/IGV/Plasmodium/Pfalciparum_PlasmoDB-5.5.gff3");
        File ofile = new File("/Users/jrobinso/IGV/Plasmodium/Pfalciparum_PlasmoDB-5.5.gff4");
        dropLinesContaining("supercontig", ifile, ofile);
    }
}
