/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * ImageCache.java
 *
 * Created on December 1, 2007, 9:59 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package org.broad.igv.util;

import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedHashMap;

/**
 *
 */
public class ObjectCache<K, V> {

    /**
     * Maximum number of objects to cache
     */
    private int maxSize = 1000;
    private LinkedHashMap<K, SoftReference<V>> map = new LinkedHashMap<K, SoftReference<V>>();

    public ObjectCache() {
        this(50);
    }

    public ObjectCache(int maxSize) {
        this.maxSize = maxSize;
        map = new LinkedHashMap<K, SoftReference<V>>(maxSize);
    }

    public void put(K key, V image) {
        if (map.size() == maxSize) {
            // Map has reached maximum size.  Remove the first(oldest) entry.
            // 
            for (K k : map.keySet()) {
                map.remove(k);
                break;
            }
        }
        SoftReference<V> SoftReference = new SoftReference<V>(image);
        map.put(key, SoftReference);
    }

    public V get(K key) {

        V image = null;
        SoftReference<V> SoftReference = map.get(key);

        if (SoftReference != null) {
            image = SoftReference.get();
        }
        return image;
    }

    public void remove(K key) {
        map.remove(key);
    }

    public boolean containsKey(K key) {
        return map.containsKey(key);
    }

    public void clear() {
        map.clear();
    }

    public int size() {
        return map.size();
    }

    public Iterator<K> iterator() {
        return map.keySet().iterator();
    }

    public int getMaxSize() {
        return maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }    
}
