/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.util;

//~--- non-JDK imports --------------------------------------------------------
import org.broad.igv.ui.action.*;
import org.broad.igv.ui.IGVMainFrame;

//~--- JDK imports ------------------------------------------------------------


import java.io.File;

import java.util.List;

/**
 *
 * @author jrobinso
 */
public class MacroSnapshotAction {

    /**
     * Loop through a list of loci creating a screenshot for each.  Method
     * assumes that data has been loaded.
     */
    final public static void doScreenshots(File regionFile, File outputDirectory) {
        doSnapshots(regionFile, outputDirectory, ".png");
    }

    final public static void doSnapshots(File regionFile, File outputDirectory, String type) {

        final List<String> loci = org.broad.igv.feature.ParsingUtils.loadRegions(regionFile);

        for (String locus : loci) {
            IGVMainFrame mainFrame = IGVMainFrame.getInstance();

            SearchCommand sa = new SearchCommand(mainFrame.getModel().getViewContext(),
                    locus);
            sa.execute();

            // Repaint
            IGVMainFrame.getInstance().repaintDataAndHeaderPanels();
            IGVMainFrame.getInstance().repaintStatusAndZoomSlider();

            String filename = locus.replaceAll(":", "_").replace("-", "_") + type;
            File file = new File(outputDirectory, filename);

            mainFrame.createSnapshotNonInteractive(file);
        }
    }
}
