/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
package org.broad.igv.util;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/**
 *
 * @author jrobinso
 */
public class LRUCache<K, V> extends LinkedHashMap<K, V> {

    Logger log = Logger.getLogger(LRUCache.class);

    private int maxEntries = 100;

    public LRUCache(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry eldest) {
        if (size() > maxEntries) {
            return true;
        } else if (RuntimeUtils.getAvailableMemoryFraction() < 0.1) {
            log.info("Memory low.  Free cache entry");
            return true;
        } else {
            return false;
        }
    }
}

