/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.broad.igv.util;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

/**
 *
 * @author eflakes
 */
abstract public class Filter {
    
    private String name;
    private LinkedHashSet<FilterElement> elements =  
        new LinkedHashSet<FilterElement>();
    private boolean isEnabled = true;
    
    public Filter(String name, List<? extends FilterElement> elements) {
        this.name = name;
        
        if(elements != null) {
            this.elements.addAll(elements);
        }
    }
    
    public void removeAll() {
        elements.clear();
    }
    public void setEnabled(boolean value) {
        isEnabled = value;
    }
    
    public boolean isEnabled() {
        return isEnabled;
    }
    
    public boolean isEmpty() {
        return elements.isEmpty();
    }
    
    public Iterator getFilterElements() {
        return elements.iterator();
    }
    
    public void add(FilterElement element) {
        elements.add(element);
    }
    
    public void remove(FilterElement element) {
        elements.remove(element);
    }
    
    /**
     * Evaluate the FilterElement set.
     * @return
     */
    abstract protected void evaluate(); 

    public String getName() {
        return name;
    }
}
