/*
* The Broad Institute
* SOFTWARE COPYRIGHT NOTICE AGREEMENT
* This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
* of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
* (the "License"); you may not use this file except in compliance with
*  the License.  You may obtain a copy of the License at
*
*    http://www.opensource.org/licenses/gpl-2.0.php
*
* This software is supplied without any warranty or guaranteed support
* whatsoever. Neither the Broad Institute nor MIT can be responsible for its
* use, misuse, or functionality.
*/



package org.broad.igv.util;

import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.WindowFunction;


/**
 *
 * @author jrobinso
 */
public class FeatureCount implements LocusScore {

    String chr;
    int start;
    int end;
    int count;

    /**
     * Constructs ...
     *
     *
     * @param chr
     * @param start
     * @param end
     */
    public FeatureCount(String chr, int start, int end) {
        this.chr = chr;
        this.start = start;
        this.end = end;
        count = 1;
    }
    

    public FeatureCount(FeatureCount fc) {
        this.chr = fc.chr;
        this.start = fc.start;
        this.end = fc.end;
        this.count = fc.count;
    }
    
    public FeatureCount copy() {
        return new FeatureCount(this);
    }

    /**
     * Method description
     *
     */
    public void incrementCount() {
        count++;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public int getCount() {
        return count;
    }



    /**
     * Method description
     *
     *
     * @return
     */
    public int getKey() {
        int hash = 5;
        hash = 43 * hash + ((this.chr != null) ? this.chr.hashCode() : 0);
        hash = 43 * hash + this.start;
        hash = 43 * hash + this.end;
        return hash;
    }
    
    public String getChr() {
        return chr;
    }

    public int getStart() {
        return start;
    }

    public void setStart(int start) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getEnd() {
        return end;
    }

    public void setEnd(int end) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public float getScore() {
        return count;
    }

    public void setConfidence(float confidence) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public float getConfidence() {
        return 1.0f;
    }

    public String getValueString(double position, WindowFunction windowFunction) {
        return "count = " + String.valueOf(count);
    }



}
