/*
* The Broad Institute
* SOFTWARE COPYRIGHT NOTICE AGREEMENT
* This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
* of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
* (the "License"); you may not use this file except in compliance with
*  the License.  You may obtain a copy of the License at
*
*    http://www.opensource.org/licenses/gpl-2.0.php
*
* This software is supplied without any warranty or guaranteed support
* whatsoever. Neither the Broad Institute nor MIT can be responsible for its
* use, misuse, or functionality.
*/

package org.broad.igv.util;

import java.io.*;


/**
*
* @author jrobinso
*/
public class ConvertPlasmodium {
    
    public static void main(String [] args) throws IOException {
        String inputDir = "/Users/jrobinso/plasmodium/Moran";
        
        for(File f : (new File(inputDir)).listFiles()) {
            
            if(f.getName().endsWith("wig")) {
            String outputName = f.getName() + ".txt";
            
            BufferedReader r = new BufferedReader(new FileReader(f));
            PrintWriter pw = new PrintWriter(new FileWriter(new File(f.getParentFile(), outputName)));
            
            String nextLine = null;
            while((nextLine = r.readLine()) != null) {
                pw.println(nextLine.replace("chrom=chr", "chrom=MAL"));
            }
            
            pw.close();
            r.close();
            }
        }
        
    }
}

