/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.util;

//~--- non-JDK imports --------------------------------------------------------
import org.apache.log4j.Logger;

import org.broad.igv.ui.GuiUtilities;
import org.broad.igv.ui.IGVMainFrame;

//~--- JDK imports ------------------------------------------------------------

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import java.io.File;

import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

/**
 *
 * @author eflakes
 */
public class UIUtilities {

    final private static StringBuffer scratchBuffer = new StringBuffer();

    /**
     * Method description
     *
     *
     * @param selectedDirectory
     * @param selectedFile
     * @param fileFilters
     *
     * @return
     */
    public static FileChooser getFileChooser(File selectedDirectory, File selectedFile,
                                               FileFilter[] fileFilters) {
        return getFileChooser(selectedDirectory, selectedFile, fileFilters, null);
    }

    /**
     * Method description
     *
     *
     * @param selectedDirectory
     * @param selectedFile
     * @param fileFilters
     * @param dialogType
     *
     * @return
     */
    public static FileChooser getFileChooser(File selectedDirectory, File selectedFile,
                                               FileFilter[] fileFilters, Integer dialogType) {

        final FileChooser fileChooser = new FileChooser(selectedDirectory) {

            boolean accepted = false;

            public void approveSelection() {
                accepted = true;
                super.approveSelection();
            }

            @Override
            public void cancelSelection() {
                setSelectedFile(null);
                super.cancelSelection();
            }

            @Override
            protected JDialog createDialog(Component parent) throws HeadlessException {
                JDialog dialog = super.createDialog(parent);
                dialog.setLocation(300, 200);
                dialog.setResizable(false);
                dialog.addWindowListener(new WindowAdapter() {

                    @Override
                    public void windowClosing(WindowEvent e) {
                        if (!accepted)
                        {
                            setSelectedFile(null);
                        }
                    }
                });
                return dialog;
            }
        };
        fileChooser.setSelectedFile(selectedFile);
        if (dialogType != null)
        {
            fileChooser.setDialogType(dialogType);
        }


        // Setup FileFilters
        if (fileFilters != null)
        {
            for (FileFilter fileFilter : fileFilters)
            {
                fileChooser.addChoosableFileFilter(fileFilter);
            }
        }

        return fileChooser;
    }

    /**
     * Method description
     *
     *
     * @param component
     * @param message
     */
    public static void showErrorMessage(Component component, final String message) {
        showAndLogErrorMessage(component, message, null);
    }

    /**
     * Method description
     *
     *
     * @param component
     * @param message
     * @param log
     * @param e
     */
    public static void showAndLogErrorMessage(final Component component, final String message,
                                                final Logger log, final Exception e) {
        if (log != null)
        {

            if (e != null)
            {
                log.error(message, e);
            } else
            {
                log.error(message);
            }
        }
        JOptionPane.showMessageDialog(component, message);

    }

    public static void showMessageDialog(final String message) {
       JOptionPane.showMessageDialog(IGVMainFrame.getInstance(), message);
    }



    /**
     * Method description
     *
     *
     * @param component
     * @param message
     * @param log
     */
    public static void showAndLogErrorMessage(Component component, String message, Logger log) {

        showAndLogErrorMessage(component, message, log, null);
    }

    /**
     * Method description
     *
     *
     * @param dialogTitle
     * @param defaultColor
     *
     * @return
     */
    public static Color showColorChooserDialog(String dialogTitle, Color defaultColor) {

        Color color = null;
        JColorChooser chooser = new JColorChooser();
        chooser.setColor(defaultColor);
        while (true)
        {

            int response = JOptionPane.showConfirmDialog(IGVMainFrame.getInstance(), chooser,
                dialogTitle, JOptionPane.OK_CANCEL_OPTION);

            if ((response == JOptionPane.CANCEL_OPTION) || (response == JOptionPane.CLOSED_OPTION))
            {
                return null;
            }

            color = chooser.getColor();
            if (color == null)
            {
                continue;
            } else
            {
                break;
            }
        }
        return color;
    }

    /**
     * Method description
     *
     *
     * @param parent
     * @param message
     *
     * @return
     */
    public static boolean showConfirmationDialog(Component parent, String message) {

        int status = JOptionPane.showConfirmDialog(parent, message, null,
            JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE, null);

        if ((status == JOptionPane.CANCEL_OPTION) || (status == JOptionPane.CLOSED_OPTION))
        {
            return false;
        }
        return true;
    }

    /**
     * Method description
     *
     *
     * @param color
     *
     * @return
     */
    public static String getcommaSeparatedRGBString(Color color) {

        if (color != null)
        {

            scratchBuffer.delete(0, scratchBuffer.length());    // Clear
            int red = color.getRed();
            int green = color.getGreen();
            int blue = color.getBlue();
            scratchBuffer.append(red);
            scratchBuffer.append(",");
            scratchBuffer.append(green);
            scratchBuffer.append(",");
            scratchBuffer.append(blue);
        }
        return scratchBuffer.toString();

    }

    /**
     * Method description
     *
     *
     * @param window
     */
    public static void centerWindow(Window window) {

        Dimension dimension = window.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - dimension.width) / 2;
        int y = (screenSize.height - dimension.height) / 2;
        window.setLocation(x, y);
        window.requestFocus();
    }
}
