/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.broad.igv.ui.util;

import javax.swing.JComponent;
import javax.swing.RepaintManager;

public class TracingRepaintManager extends RepaintManager {
    
   @Override
   public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
      try {
         throw new Exception();
      } catch (Exception exc) {
         StringBuffer sb = new StringBuffer();
         StackTraceElement[] stack = exc.getStackTrace();
         int count = 0;
         for (StackTraceElement stackEntry : stack) {
            if (count++ > 8)
               break;
            sb.append("\t");
            sb.append(stackEntry.getClassName() + ".");
            sb.append(stackEntry.getMethodName() + " [");
            sb.append(stackEntry.getLineNumber() + "]");
            sb.append("\n");
         }
         System.out.println("**** Repaint stack ****");
         System.out.println(sb.toString());
      }

      super.addDirtyRegion(c, x, y, w, h);
   }
}
