/*
* The Broad Institute
* SOFTWARE COPYRIGHT NOTICE AGREEMENT
* This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
* of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
* (the "License"); you may not use this file except in compliance with
*  the License.  You may obtain a copy of the License at
*
*    http://www.opensource.org/licenses/gpl-2.0.php
*
* This software is supplied without any warranty or guaranteed support
* whatsoever. Neither the Broad Institute nor MIT can be responsible for its
* use, misuse, or functionality.
*/

package org.broad.igv.ui.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;


/**
*
* @author eflakes
*/
public class ProgressMonitor {
    
    final public static String PROGRESS_PROPERTY = "PROGRESS_PROPERTY";
    
    private boolean isReady = false;
    private int oldValue = 0;
    private Object source;
    private PropertyChangeSupport propertyChangeSupport;
    
    public ProgressMonitor() {
        this.source = this;
        propertyChangeSupport = new PropertyChangeSupport(source);
        setReady(true);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        propertyChangeSupport.addPropertyChangeListener(listener);
    }
    
    /**
     * Sends an event to update the listening progress bar. 
     * @param value This value is the percent amount to add to the current 
     * progress in the progress bar (which goes from zero to 100). 
     */
    synchronized public void fireProgressChange(int value) {      
        
        if(isReady) {
            final int newValue = oldValue + value;

            PropertyChangeEvent event = 
                new PropertyChangeEvent(
                    source, 
                    PROGRESS_PROPERTY,
                    oldValue,
                    newValue);
            propertyChangeSupport.firePropertyChange(event);
            oldValue = newValue;
        }
    }
    
    /**
     * Sets whether or not this class will respond to progress requests.
     * @param ready
     */
    public void setReady(boolean ready) {
        isReady = ready;
    }
    
    /**
     * returns whether or not this class will respond to progress requests.
     * @return
     */
    public boolean isReady() {
        return isReady;
    }
}