/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * MenuAndToolbarUtils.java
 *
 * Created on November 7, 2007, 1:34 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.broad.igv.ui.util;

import com.jidesoft.action.CommandBar;
import java.awt.Color;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.plaf.basic.BasicBorders;
import org.broad.igv.ui.action.MenuAction;

/**
 *
 * @author eflakes
 */
public class MenuAndToolbarUtils {

    static public JMenuBar createMenuBar(List<AbstractButton> menus) {
        
        JMenuBar menuBar = new JMenuBar();
        menuBar.setBorder(new BasicBorders.MenuBarBorder(Color.GRAY, Color.GRAY));
        menuBar.setBorderPainted(true);
        for(AbstractButton menu : menus) {
            menuBar.add(menu);
        }

        return menuBar;
    }


    static public CommandBar createToolBar(List<JComponent> actionComponent) {
        
        CommandBar toolBar = new CommandBar();

        if(actionComponent != null) {
            for(JComponent action : actionComponent) {
                toolBar.add(action);
            }
        }

        return toolBar;
    }

    static public JMenu createMenu(List<JComponent> menuItems, MenuAction action) {
        
        final JMenu menu = new JMenu();
        menu.setAction(action);
        
        for(JComponent menuItem : menuItems) {
            menu.add(menuItem);
        }
        
        String text = action.getToolTipText();
        if(text != null) {
            menu.setToolTipText(text);
        }
        
        return menu;
    }

    static public JMenuItem createMenuItem(MenuAction menuItemAction) {

        JMenuItem menuItem = new JMenuItem();
        menuItem.setAction(menuItemAction);
        
        String text = menuItemAction.getToolTipText();
        if(text != null) {
            menuItem.setToolTipText(text);
        }
        
        return menuItem;
    }

    static public JCheckBoxMenuItem createMenuItem(MenuAction menuItemAction, boolean isSelected) {

        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem();
        menuItem.setSelected(isSelected);
        menuItem.setAction(menuItemAction);
        
        String text = menuItemAction.getToolTipText();
        if(text != null) {
            menuItem.setToolTipText(text);
        }
        
        return menuItem;
    }
}
