/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

package org.broad.igv.ui.util;

import com.jidesoft.swing.JideButton;
import java.awt.Color;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.igv.util.BrowserLauncher;

/*
 * LinkLabel.java
 *
 * Created on August 18, 2008, 11:27 AM
 */



/**
 *
 * @author  eflakes
 */
public class LinkLabel extends javax.swing.JPanel {

    private static Logger log = Logger.getLogger(LinkLabel.class);
    private String hyperLink;
    
    /** Creates new form LinkLabel */
    public LinkLabel() {
        initComponents();
        setOpaque(true);
    }
    
    public void showHyperLink(boolean value) { 
        
        if(jButton1 != null) {
            jButton1.setVisible(value);
        }
    }
                
    @Override
    public void setEnabled(boolean value) { 
        super.setEnabled(value);
        
        if(jLabel1 != null) {
            jLabel1.setEnabled(value);
        }
    }
    
    public void setText(String value) {
        if(jLabel1 != null) {
            jLabel1.setText(value);
        }
    }
    
    public String getText() {
        if(jLabel1 != null) {
        return jLabel1.getText();
        }
        else {
            return null;
        }
    }
    
    public void setHyperLink(String value) {
        hyperLink = value;
    }
    
    public String getHyperLink() {
        return hyperLink;
    }
    
    @Override
    public void setBackground(Color value) {
        super.setBackground(value);
        if(jLabel1 != null) {
            jLabel1.setBackground(value);
        }
    }
    
    @Override
    public void setForeground(Color value) {
        super.setForeground(value);
        if(jLabel1 != null) {
            jLabel1.setForeground(value);
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jButton1 = new JideButton();

        setMaximumSize(new java.awt.Dimension(32767, 25));
        setMinimumSize(new java.awt.Dimension(25, 25));
        setRequestFocusEnabled(false);
        setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT, 2, 0));

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel1.setText("Text");
        jLabel1.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jLabel1.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        jLabel1.setMaximumSize(new java.awt.Dimension(32767, 22));
        jLabel1.setMinimumSize(new java.awt.Dimension(22, 22));
        jLabel1.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        add(jLabel1);

        jButton1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Information16.gif"))); // NOI18N
        jButton1.setBorder(null);
        jButton1.setBorderPainted(false);
        jButton1.setFocusPainted(false);
        jButton1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jButton1.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        jButton1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButton1.setMaximumSize(new java.awt.Dimension(15, 15));
        jButton1.setMinimumSize(new java.awt.Dimension(15, 15));
        jButton1.setPreferredSize(new java.awt.Dimension(15, 15));
        jButton1.setRolloverEnabled(false);
        jButton1.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Information16.gif"))); // NOI18N
        jButton1.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jButton1.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        add(jButton1);
    }// </editor-fold>//GEN-END:initComponents

private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
    try {
        BrowserLauncher.openURL(hyperLink);
    }
    catch(IOException e) {
        log.error("Error launching from hyperlink", e);
    }
}//GEN-LAST:event_jButton1ActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    // End of variables declaration//GEN-END:variables

}
