/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.util;

import java.util.Timer;
import java.util.TimerTask;
import org.broad.igv.ui.GuiUtilities;

/**
 *
 * @author jrobinso
 */
public class IndefiniteProgressMonitor extends ProgressMonitor {

    int cycleTime;
    Timer timer;

    public IndefiniteProgressMonitor(int cycleTime) {
        this.cycleTime = cycleTime;
        timer = new Timer();
        setReady(true);
    }

    public void start() {
        timer.schedule(new CycleTask(), 0, 1000);
    }

    public void stop() {
        timer.cancel();
        fireProgressChange(100);
    }

    class CycleTask extends TimerTask {

        boolean stop = false;
        int progress = 0;
        int progressIncrement = 0;
        int direction = 1;
        long lastTime = System.currentTimeMillis();

        @Override
        public void run() {


            GuiUtilities.invokeOnEventThread(new Runnable() {
                public void run() {
                    fireProgressChange(progressIncrement);
                }
            });

            

            long t = System.currentTimeMillis();
            progressIncrement = (int)(direction * (t - lastTime) / (10 * cycleTime));
            progress += progressIncrement;
            if (progress >= 90) {
                progress = 99;
                direction = -1;
            } else if (progress <
                    0) {
                progress = 1;
                direction = 1;
            }
            lastTime = t;
        }
    }
}
