/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/



package org.broad.igv.ui.util;

//~--- non-JDK imports --------------------------------------------------------


import com.jidesoft.status.LabelStatusBarItem;
import com.jidesoft.status.MemoryStatusBarItem;
import com.jidesoft.status.StatusBar;
import com.jidesoft.swing.JideBoxLayout;

import org.apache.log4j.Logger;

import org.broad.igv.ui.GuiUtilities;

//~--- JDK imports ------------------------------------------------------------

import java.awt.Dimension;

import java.text.DecimalFormat;

import javax.swing.JLabel;


/**
 *
 * @author eflakes
 */
public class ApplicationStatusBar extends StatusBar {

    static Logger log = Logger.getLogger(ApplicationStatusBar.class);
    private LabelStatusBarItem messageBox;
    private LabelStatusBarItem messageBox2;
    private MemoryStatusBarItem memoryBox;
    DecimalFormat formatter = new DecimalFormat();

    /**
     * Constructs ...
     *
     */
    public ApplicationStatusBar() {
        initialize();
    }

    private void initialize() {

        messageBox = new LabelStatusBarItem("Line");
        messageBox.setAlignment(JLabel.LEFT);
        messageBox.setMinimumSize(new Dimension(170, 10));
        add(messageBox, JideBoxLayout.FLEXIBLE);

        messageBox2 = new LabelStatusBarItem("Line");
        add(messageBox2, JideBoxLayout.VARY);

        memoryBox = new MemoryStatusBarItem();
        add(memoryBox, JideBoxLayout.FLEXIBLE);
    }

    /**
     * Method description
     *
     *
     * @param message
     */
    public void setMessage(final String message) {
        GuiUtilities.invokeOnEventThread(new Runnable() {

            public void run() {
                messageBox.setText(message);
                messageBox.paintImmediately(messageBox.getBounds());
            }
        });
    }
}
