/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.panel;

import org.broad.igv.ui.util.Tool;
import org.broad.igv.ui.util.Packable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.broad.igv.ui.GuiUtilities;

/**
 *
 * @author eflakes
 */
public class View extends JPanel {

    public static int X_SPACING_BETWEEN_COMPONENTS = 10;

    private String viewName = "View";
    private Tool tool;

    public Tool getTool() {
        return tool;
    }

    public void setTool(Tool tool) {
        this.tool = tool;
    }
    
    public int getViewportHeight() {

        int height = 0;
        Container parent = getParent();

        if (parent instanceof JViewport) {
            height = ((JViewport)parent).getHeight();
        } else {
            height = parent.getHeight();
        }
        
        return height;
    }

    /**
     * Scrollpane height
     * @return
     */
    public int getScrollPaneHeight() {

        int height = 0;
        Container parent = getParent();

        if (parent instanceof JViewport) {
            height = ((JViewport)parent).getParent().getHeight();
        } else {
            height = parent.getHeight();
        }
        
        return height;
    }

    public int getViewportWidth() {

        int width = 0;
        Container parent = getParent();

        if (parent instanceof JViewport) {
            width = (int)((JViewport)parent).getViewSize().getWidth();
        } else {
            width = parent.getWidth();
        }

        return width;
    }

    public int getScrollPaneWidth() {

        int width = 0;
        Container parent = getParent();

        if (parent instanceof JViewport) {
            width = (int)((JViewport)parent).getParent().getWidth();
        } else {
            width = parent.getWidth();
        }

        return width;
    }

    public JViewport getViewport() {

        JViewport viewport = null;
        Container parent = getParent();

        if (parent instanceof JViewport) {
            viewport = ((JViewport) parent);
        }
        return viewport;
    }

    public JScrollPane getScrollPane() {
        
        JScrollPane scollpane = null;
        Container parent = getParent();

        if (parent instanceof JViewport) {
            scollpane = (JScrollPane)((JViewport)parent).getParent();
        }
        return scollpane;
    }

    public void setHeight(int height) {

        if (height < 0) {
            height = 0;
        }

        // First resize itself
        final Dimension dimension = new Dimension(getWidth(), height);
        setSize(dimension);
        setPreferredSize(dimension);

        // Then resize its children
        Component[] children = getComponents();
        for (final Component child : children) {

            final Dimension childDimension =
                    new Dimension(child.getWidth(), height);

            GuiUtilities.invokeOnEventThread(new Runnable() {

                public void run() {
                    child.setSize(childDimension);
                    child.setPreferredSize(childDimension);
                }
            });
        }
    }

    public String getViewName() {
        return viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public void packView() {

        GuiUtilities.invokeOnEventThread(new Runnable() {

            public void run() {

                Integer attributePanelEnd = null;
                int width = 0;

                // Pack the attribute panels
                Component[] children = getComponents();
                for (final Component child : children) {
                    if (child instanceof Packable) {
                        ((Packable)child).packComponent();
                        
                        if(attributePanelEnd == null) {                
                            int x = child.getX();
                            width = child.getWidth();
                            attributePanelEnd = new Integer(x+width);
                        }
                    }
                }

                // Change Track and Header panel X location
                if (attributePanelEnd != null) {
                    
                    children = getComponents();
                    for (final Component child : children) {
                        
                        if (child instanceof DataPanel || 
                            child instanceof HeaderPanel) {
                            
                            if(width > 0) {
                                attributePanelEnd += X_SPACING_BETWEEN_COMPONENTS;
                            }
                            child.setLocation((attributePanelEnd), child.getY());
                        }
                    }
                }
                
            }
        });
    }
}
