/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
package org.broad.igv.ui.panel;

//~--- non-JDK imports --------------------------------------------------------
import java.awt.Dimension;
import java.awt.LayoutManager;
import org.broad.igv.IGVConstants;
import org.broad.igv.ui.panel.View;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.track.TrackManager;

//~--- JDK imports ------------------------------------------------------------


import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

/**
 *
 * @author eflakes
 */
public class TrackSetView extends View {

    private String name = null;
    private TrackNamePanel namePanel;
    private AttributePanel attributePanel;
    private DataPanel dataPanel;

    /**
     * Constructs ...
     *
     *
     * @param name
     */
    public TrackSetView(String name) {
        this.name = name;
        init();
    }

    /**
     * This override is a "hack" to get around the netbeans visual editor's insistence on setting
     * a layout after component initialization
     * @param layout
     */
    @Override
    public void setLayout(LayoutManager layout) {
        if(layout != null) {
            super.setLayout(layout);
        }
    }



    private void init() {
        setLayout(new AbsoluteLayout());
        namePanel = new TrackNamePanel();
        attributePanel = new AttributePanel();
        dataPanel = new DataPanel();
        add(namePanel, new AbsoluteConstraints(0, 0, 150, 230));
        add(attributePanel, new AbsoluteConstraints(160, 0, 120, 230));
        add(dataPanel, new AbsoluteConstraints(290, 0, 710, 230));
    }

    public String getName() {
        return name;
    }

    
    protected List<Track> getAllTracks() {
        return TrackManager.getInstance().getTracksForPanel(name);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Collection<TrackGroup> getGroups() {
        return TrackManager.getInstance().getTrackGroups(name);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean hasTracks() {
        return (!getAllTracks().isEmpty());
    }


    /**
     * Method description
     *
     *
     * @return
     */
    public int getPreferredPanelHeight() {
        int height = 0;

        // Copy to prevent concurrent modification exception.  Should we synchronize on the 
        // groups collection instead?
        Collection<TrackGroup> groups = getGroups();

        if (groups.size() > 1) {
            height += IGVConstants.groupGap;
        }

        for (Iterator<TrackGroup> groupIter = groups.iterator(); groupIter.hasNext();) {
            TrackGroup group = groupIter.next();
            if (group != null && group.isVisible()) {
                if (groups.size() > 1) {
                    height += IGVConstants.groupGap;
                }
                height += group.getPreferredHeight();
            }
        }

        return Math.max(20, height);
    }

    /**
     * @return the namePanel
     */
    public TrackNamePanel getNamePanel() {
        return namePanel;
    }

    /**
     * @return the attributePanel
     */
    public AttributePanel getAttributePanel() {
        return attributePanel;
    }

    /**
     * @return the dataPanel
     */
    public DataPanel getDataPanel() {
        return dataPanel;
    }
}
