/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.panel;

import com.jidesoft.swing.JideScrollPane;
import java.awt.Component;
import javax.swing.ScrollPaneConstants;
import org.broad.igv.track.TrackManager;

/**
 *
 * @author jrobinso
 */
public class TrackSetScrollPane extends JideScrollPane {

    TrackSetView trackSetView;

    @Override
    public void setViewportView(Component trackSetView) {
        if (!(trackSetView instanceof TrackSetView)) {
            throw new IllegalArgumentException(
                    "Class TrackSetScrollPane can only contain a TrackSetView");
        }
        super.setViewportView(trackSetView);
        this.trackSetView = (TrackSetView) trackSetView;
        this.verticalScrollBar.addAdjustmentListener(getNamePanel());
        init();
    }

    public TrackSetView getTrackSetView() {
        return trackSetView;
    }

    @Override
    public String getName() {
        return trackSetView.getName();
    }

    public void minimizeHeight() {
        int prefHeight = trackSetView.getPreferredPanelHeight();
        if(prefHeight < trackSetView.getViewportHeight()) {
            this.setSize(getWidth(), prefHeight);
        }
    }

    public DataPanel getDataPanel() {
        return trackSetView.getDataPanel();
    }

    public boolean isEmpty() {
        return trackSetView.getAllTracks().isEmpty();
    }

    public TrackNamePanel getNamePanel() {
        return trackSetView.getNamePanel();
    }

    public AttributePanel getAttributePanel() {
        return trackSetView.getAttributePanel();
    }

    private void init() {
        setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(102, 102, 102)));
        setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        setFocusTraversalPolicyProvider(true);
        setMinimumSize(new java.awt.Dimension(0, 0));
        setOpaque(false);
    }
}
