/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.panel;

import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashSet;
import java.util.Set;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackManager;

/**
 * Regions that represent tracks
 */
public class MouseableRegion {

    private Shape region;
    private String text;
    private TrackCltn trackCltn;

    /**
     * 
     */
    public MouseableRegion(Shape region, Track track) {

        this.region = region;
        this.text = track.getDisplayName();
        trackCltn = new SingleTrackRegion(track);
    }

    public MouseableRegion(Shape region, String key, String value) {

        this.region = region;
        this.text = key + " = " + value;
        trackCltn = new AttributePanelRegion(key, value);
    }

    public boolean containsTrack(Track t) {
        return trackCltn.contains(t);
    }

    /**
     * Method description
     *
     *
     * @param x
     * @param y
     *
     * @return
     */
    public boolean containsPoint(double x, double y) {
        return region.contains(x, y);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Rectangle getBounds() {
        return region.getBounds();
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String getText() {
        return text;
    }

    /**
     * 
     */
    public boolean hasTracks() {
        return trackCltn.hasTracks();
    }

    /**
     * 
     */
    public Set<Track> getTracks() {
        return trackCltn.getTracks();
    }

    /**
     * Method description
     *
     *
     * @return
     */
    @Override
    public String toString() {
        return region.toString();
    }

    interface TrackCltn {

        public boolean hasTracks();

        public Set<Track> getTracks();

        public boolean contains(Track t);
    }

    class SingleTrackRegion implements TrackCltn {

        private Set<Track> tracks;

        /**
         * Constructs ...
         *
         *
         * @param region
         * @param track
         */
        public SingleTrackRegion(Track track) {
            tracks = new HashSet<Track>();
            tracks.add(track);
        }

        public boolean hasTracks() {
            return ((tracks == null) || tracks.isEmpty()) ? false : true;
        }

        public Set<Track> getTracks() {
            return tracks;
        }

        public boolean contains(Track t) {
            return tracks.contains(t);
        }
    }

    class AttributePanelRegion implements TrackCltn {

        private String key;
        private String value;

        /**
         * Constructs ...
         *
         *
         * @param region
         * @param key
         * @param value
         */
        public AttributePanelRegion(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public boolean hasTracks() {
            return (getTracks().isEmpty()) ? false : true;
        }

        public Set<Track> getTracks() {
            Set<Track> selectedTracks = new HashSet();
            for (Track track : TrackManager.getInstance().getAllTracks(true)) {
                String attributeValue = track.getAttributeValue(key);
                if (attributeValue == null) {
                    continue;
                }
                if (attributeValue.equals(value)) {
                    selectedTracks.add(track);
                }
            }
            return selectedTracks;
        }

        public boolean contains(Track t) {
            return getTracks().contains(t);
        }
    }
}
