/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.panel;

import org.broad.igv.ui.*;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideButton;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.broad.igv.util.BrowserLauncher;
import static org.broad.igv.IGVConstants.*;

/**
 * Information panel.  Displayed in upper left corner
 * 
 * @author jrobinso
 */
public class InfoPanel extends JPanel {

    JideButton genomeButton;
    JideButton helpButton;

    public InfoPanel() {
        initComponents();

    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        // Ignore layout manager settings
    }
    JEditorPane infoArea;

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);

    }

    protected void initComponents() {

        JideBoxLayout layout = new JideBoxLayout(this, JideBoxLayout.Y_AXIS, 2);
        super.setLayout(layout);


        this.add(Box.createHorizontalStrut(10), JideBoxLayout.FIX);

        /* helpButton = new JideButton("Getting started ...");
        helpButton.setForeground(Color.BLUE.darker());
        helpButton.setButtonStyle(ButtonStyle.HYPERLINK_STYLE);
        helpButton.setHorizontalAlignment(SwingConstants.LEFT);
        helpButton.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent actionevent) {
        JOptionPane.showMessageDialog(null, "Under construction");
        }
        });
        this.add(helpButton, JideBoxLayout.FIX);
         * */


        infoArea = new JEditorPane();
        infoArea.setContentType("text/html");
        infoArea.setFont(FontManager.getScalableFont(12));
        // infoArea.setBorder(BorderFactory.createEmptyBorder());

        infoArea.setMargin(new Insets(5, 5, 5, 5));
        infoArea.setEditable(false);
        //infoArea.setLineWrap(true);
        //infoArea.setWrapStyleWord(true);
        //addQuickstartLink();
        this.add(infoArea, JideBoxLayout.VARY);

    //updateHelpText();



    }

    public void updateHelpText() {
        /*infoArea.setText("<html>" + getHelpText()); 
        +
        "<p><a href=\"" + SERVER_BASE_URL + "doc/quickstart.html\">Quick start guide</a>");
        
        infoArea.addHyperlinkListener(new HyperlinkListener() {

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkevent) {
        try {
        if (hyperlinkevent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
        BrowserLauncher.openURL(hyperlinkevent.getURL().toString());
        }
        } catch (IOException ex) {
        com.jidesoft.dialog.JideOptionPane.showMessageDialog(infoArea, "Cannot connect to tutorial.");
        }
        }
        });
         * */
    }

    private String getHelpText() {
        return "";
    }
}
