/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/



/*
* To change this template, choose Tools | Templates
* and open the template in the editor.
 */
package org.broad.igv.ui.legend;

//~--- non-JDK imports --------------------------------------------------------

import org.broad.igv.ui.*;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Mutation;
import org.broad.igv.ui.util.PropertyDialog;
import org.broad.igv.ui.util.PropertyDialog.PreferenceDescriptor;
import org.broad.igv.renderer.ColorScale;
import org.broad.igv.ui.WaitCursorManager.CursorToken;

import org.broad.igv.util.ColorUtilities;

import static org.broad.igv.ui.util.PropertyDialog.PreferenceType.*;

//~--- JDK imports ------------------------------------------------------------

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;

import java.util.LinkedHashMap;
import java.util.Map;

import javax.swing.SwingUtilities;

/**
 * Panel to paint a legend for the mutation tracks.
 * TODO -- combine with other legend panels in a general
 * @author jrobinso
 */
public class MutationLegendPanel extends LegendPanel {


    /*
     *     public HeatmapLegendPanel(TrackType type) {
     *   this.type = type;
     *   ColorScale colorScale = ColorScaleFactory.getColorScale(type);
     *
     *   //TODO -- temporary hack.  We need some specific knowledge fo the implementation
     *   //in order to edit it,  but do it without a cast
     *   this.colorScale = (ContinuousColorScale) colorScale;
     * }
     *
     * protected void persistResetPreferences() {
     *   ColorScaleFactory.setColorScheme(type, colorScale);
     * }
     *
     * protected void resetPreferencesToDefault() {
     *   colorScale = (ContinuousColorScale) ColorScaleFactory.getDefaultColorSchemeByType(type);
     *   persistResetPreferences();
     *   showResetDisplay();
     * }
     *
     * protected void reloadPreferences() {
     *   ColorScaleFactory.setColorScheme(type, colorScale);
     *   HeatmapRenderer.clearColorSchemeCache();
     *   repaint();
     * }
     */

    protected void persistResetPreferences() {
        PreferenceManager.getInstance().setMutationColorScheme(Mutation.getColorScheme());
    }

    protected void reloadPreferences() {
        Mutation.reloadPreferences();

        // ColorScaleFactory.clearCache();
        repaint();
    }

    protected ColorScale getColorScale() {

        // TODO Refactor the base class this empty method is not needed
        return null;
    }

    @Override
    protected void resetPreferencesToDefault() {
        Mutation.setColorScheme(Mutation.getDefaultColorScheme());
        persistResetPreferences();
        showResetDisplay();
    }

    /**
     * Open the user preferences dialog
     */
    public void doUserPreferences() {

        GuiUtilities.invokeOnEventThread(new Runnable() {

            public void run() {

                IGVMainFrame.getInstance().setStatusBarMessage("Setting view properties...");

                // Add view preference items to the display
                LinkedHashMap<String, PreferenceDescriptor> labelTextToKey = addPreferences();

                Window window = SwingUtilities.getWindowAncestor(MutationLegendPanel.this);

                // Create dialog
                PropertyDialog dialog = new PropertyDialog(PreferenceManager.getInstance(),
                                            labelTextToKey, (Dialog) window, true);

                Component parent = IGVMainFrame.getInstance();

                dialog.setLocationRelativeTo(parent);
                dialog.setTitle("Color Preferences");
                dialog.setVisible(true);


                if (dialog.isCanceled())
                {
                    IGVMainFrame.getInstance().resetStatusMessage();
                    return;
                }

                try
                {
                    reloadPreferences();

                }
                finally
                {

                    GuiUtilities.invokeOnEventThread(new Runnable() {
                        public void run() {
                            SwingUtilities.getWindowAncestor(MutationLegendPanel.this).toFront();
                        }
                    });

                    IGVMainFrame.getInstance().clearImageCacheForTrackPanels();
                    IGVMainFrame.getInstance().resetStatusMessage();
                }

            }
        });
    }

    protected LinkedHashMap<String, PreferenceDescriptor> addPreferences() {

        LinkedHashMap<String, PreferenceDescriptor> labelTextToKey = new LinkedHashMap<String,
                                                                         PreferenceDescriptor>();

        addIndelColorPreference(labelTextToKey);
        addMissenseColorPreference(labelTextToKey);
        addNonsenseColorPreference(labelTextToKey);
        addSpliceSiteColorPreference(labelTextToKey);
        addSynonymousColorPreference(labelTextToKey);
        addTargetRegionColorPreference(labelTextToKey);
        addUnknownColorPreference(labelTextToKey);

        return labelTextToKey;
    }

    protected void addNonsenseColorPreference(LinkedHashMap<String,
            PreferenceDescriptor> labelTextToKey) {

        Color color = Mutation.getColorScheme().get(Mutation.Type.Nonsense);
        String labelText = "Nonsense Color: ";

        labelTextToKey.put(labelText,
                           new PreferenceDescriptor(PreferenceManager.MUTATION_NONSENSE_COLOR_KEY,
                               COLOR, ColorUtilities.convertColorToRGBString(color)));
    }

    protected void addIndelColorPreference(LinkedHashMap<String,
            PreferenceDescriptor> labelTextToKey) {

        Color color = Mutation.getColorScheme().get(Mutation.Type.Indel);
        String labelText = "Indel Color: ";

        labelTextToKey.put(labelText,
                           new PreferenceDescriptor(PreferenceManager.MUTATION_INDEL_COLOR_KEY,
                               COLOR, ColorUtilities.convertColorToRGBString(color)));
    }

    protected void addTargetRegionColorPreference(LinkedHashMap<String,
            PreferenceDescriptor> labelTextToKey) {

        Color color = Mutation.getColorScheme().get(Mutation.Type.Targeted_Region);
        String labelText = "Target Region Color: ";

        labelTextToKey.put(
            labelText,
            new PreferenceDescriptor(
                PreferenceManager.MUTATION_TARGETED_REGION_COLOR_KEY, COLOR,
                ColorUtilities.convertColorToRGBString(color)));
    }

    protected void addMissenseColorPreference(LinkedHashMap<String,
            PreferenceDescriptor> labelTextToKey) {

        Color color = Mutation.getColorScheme().get(Mutation.Type.Missense);
        String labelText = "Missense Color: ";

        labelTextToKey.put(labelText,
                           new PreferenceDescriptor(PreferenceManager.MUTATION_MISSENSE_COLOR_KEY,
                               COLOR, ColorUtilities.convertColorToRGBString(color)));
    }

    protected void addSpliceSiteColorPreference(LinkedHashMap<String,
            PreferenceDescriptor> labelTextToKey) {

        Color color = Mutation.getColorScheme().get(Mutation.Type.Splice_site);
        String labelText = "Splice Site Color: ";

        labelTextToKey.put(
            labelText,
            new PreferenceDescriptor(
                PreferenceManager.MUTATION_SPLICE_SITE_COLOR_KEY, COLOR,
                ColorUtilities.convertColorToRGBString(color)));
    }

    protected void addSynonymousColorPreference(LinkedHashMap<String,
            PreferenceDescriptor> labelTextToKey) {

        Color color = Mutation.getColorScheme().get(Mutation.Type.Synonymous);
        String labelText = "Synonymous Color: ";

        labelTextToKey.put(
            labelText,
            new PreferenceDescriptor(
                PreferenceManager.MUTATION_SYNONYMOUS_COLOR_KEY, COLOR,
                ColorUtilities.convertColorToRGBString(color)));
    }

    protected void addUnknownColorPreference(LinkedHashMap<String,
            PreferenceDescriptor> labelTextToKey) {

        Color color = Mutation.getColorScheme().get(Mutation.Type.Unknown);
        String labelText = "Unknown Color: ";

        labelTextToKey.put(labelText,
                           new PreferenceDescriptor(PreferenceManager.MUTATION_UNKNOWN_COLOR_KEY,
                               COLOR, ColorUtilities.convertColorToRGBString(color)));
    }

    /**
     * Method description
     *
     *
     * @param g
     */
    @Override
    public void paintLegend(Graphics g) {

        Map<Mutation.Type, Color> theColorScheme = Mutation.getColorScheme();

        if (theColorScheme == null)
        {
            return;
        }

        Graphics2D g2D = null;

        try
        {
            g2D = (Graphics2D) g.create();

            g2D.setFont(FontManager.getScalableFont(10));

            FontMetrics fm = g2D.getFontMetrics();
            int dh = fm.getHeight() / 2 + 3;

            int x = 0;
            int lineHeight = 12;
            int y = lineHeight;
            int colCount = 0;

            for (Map.Entry<Mutation.Type, Color> entry : theColorScheme.entrySet())
            {

                Mutation.Type mutType = entry.getKey();
                String label = mutType.toString().replace("_", " ");
                int labelWidth = (int) fm.getStringBounds(label, g2D).getWidth();

                g2D.setColor(entry.getValue());
                g2D.fillRect(x, y, 10, 10);
                g2D.setColor(Color.BLACK);
                g2D.drawRect(x, y, 10, 10);
                g2D.drawString(label, x + 20, y + dh);
                x += labelWidth + 40;
                colCount++;

                if (colCount % 5 == 0)
                {
                    y += lineHeight + 5;
                    x = 0;
                }
            }

        }
        finally
        {
            g2D.dispose();
        }
    }
}
