/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.legend;

import org.broad.igv.ui.*;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.broad.igv.track.TrackType;

/**
 *
 * @author jrobinso
 */
public class LohLegendPanel extends HeatmapLegendPanel {
    
    
    public LohLegendPanel() {
        super(TrackType.LOH);
    }
    

    @Override
    public void paintLegend(Graphics g) {

        Graphics2D g2D = null;

        try {
            g2D = (Graphics2D) g.create();

            g2D.setFont(FontManager.getScalableFont(10));
            FontMetrics fm = g2D.getFontMetrics();
            int dh = fm.getHeight() / 2 + 3;

            
            int x = 0;
            int y = getHeight() / 2;

            String label = "Loss";
            int labelWidth = (int) fm.getStringBounds(label, g2D).getWidth();
            g2D.setColor(colorScale.getMaxColor());
            g2D.fillRect(x, y, 10, 10);
            g2D.setColor(Color.BLACK);
            g2D.drawRect(x, y, 10, 10);
            g2D.drawString(label, x + 20, y + dh);
            x += labelWidth + 60;

            label = "Retained";
            labelWidth = (int) fm.getStringBounds(label, g2D).getWidth();
            g2D.setColor(colorScale.getMidColor());
            g2D.fillRect(x, y, 10, 10);
            g2D.setColor(Color.BLACK);
            g2D.drawRect(x, y, 10, 10);
            g2D.drawString(label, x + 20, y + dh);
            x += labelWidth + 60;

            label = "Conflict";
            labelWidth = (int) fm.getStringBounds(label, g2D).getWidth();
            g2D.setColor(colorScale.getMinColor());
            g2D.fillRect(x, y, 10, 10);
            g2D.setColor(Color.BLACK);
            g2D.drawRect(x, y, 10, 10);
            g2D.drawString(label, x + 20, y + dh);
            x += labelWidth + 60;

        } finally {
            g2D.dispose();
        }
    }
}
