/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/



/*
* To change this template, choose Tools | Templates
* and open the template in the editor.
 */
package org.broad.igv.ui.legend;

//~--- non-JDK imports --------------------------------------------------------

import org.broad.igv.ui.*;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.WaitCursorManager.CursorToken;

//~--- JDK imports ------------------------------------------------------------

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

/**
 *
 * @author jrobinso
 */
abstract public class LegendPanel extends JPanel {

    protected TrackType type;
    private MouseInputListener mouseListener;
    private WaitCursorManager.CursorToken token;

    /**
     * Constructs ...
     *
     */
    public LegendPanel() {

        mouseListener = new MouseInputAdapter() {

            @Override
            public void mouseEntered(MouseEvent e) {

                LegendPanel.this.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
            }

            @Override
            public void mouseExited(MouseEvent e) {}

            @Override
            public void mouseClicked(MouseEvent e) {
                doUserPreferences();
            }
        };
        addMouseListener(mouseListener);

        GuiUtilities.invokeOnEventThread(new Runnable() {

            public void run() {
                LegendPanel.this.setToolTipText(UIConstants.CLICK_ITEM_TO_EDIT_TOOLTIP);
            }
        });
    }

    abstract protected void resetPreferencesToDefault();

    protected void showResetDisplay() {
        try
        {
            reloadPreferences();

        }
        finally
        {

            IGVMainFrame.getInstance().clearImageCacheForTrackPanels();
            IGVMainFrame.getInstance().resetStatusMessage();
        }

    }

    /**
     * Method description
     *
     *
     * @param type
     */
    public void setTrackType(TrackType type) {
        this.type = type;
    }

    /**
     * Method description
     *
     *
     * @param g
     */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        paintLegend(g);
    }

    abstract protected void paintLegend(Graphics g);

    /**
     * Open the user preferences dialog
     */
    abstract public void doUserPreferences();

    /*
     * protected void setColorScheme(double minimum, double median, double maximum,
     * Color minColor, Color medianColor, Color maxColor) {
     * colorScheme =
     * new ContinuousColorScale(minimum, maximum,
     * minColor, medianColor, maxColor, median, median);
     * }
     */

    // abstract protected LinkedHashMap<String, PreferenceDescriptor> addPreferences();

    abstract protected void reloadPreferences();

    abstract protected void persistResetPreferences();
}
