/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/



/*
* To change this template, choose Tools | Templates
* and open the template in the editor.
 */
package org.broad.igv.ui.legend;

//~--- non-JDK imports --------------------------------------------------------

import org.broad.igv.ui.*;
import org.apache.log4j.Logger;

//static imort
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.track.TrackType;

//~--- JDK imports ------------------------------------------------------------

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

import java.text.DecimalFormat;

import javax.swing.SwingUtilities;
import org.broad.igv.PreferenceManager;
import org.broad.igv.ui.WaitCursorManager.CursorToken;

/**
 *
 * @author eflakes
 */
public class HeatmapLegendPanel extends LegendPanel {

    static Logger log = Logger.getLogger(HeatmapLegendPanel.class);

    private TrackType type;
    protected ContinuousColorScale colorScale;

    /**
     * Constructs ...
     *
     *
     * @param type
     */
    public HeatmapLegendPanel(TrackType type) {
        this.type = type;

        // TODO -- temporary hack.  We need some specific knowledge fo the implementation
        // in order to edit it,  but do it without a cast
        this.colorScale = (ContinuousColorScale) PreferenceManager.getInstance().getColorScale(type);
    }

    protected void persistResetPreferences() {
        PreferenceManager.getInstance().setColorScale(type, colorScale);
    }

    protected void resetPreferencesToDefault() {
        // TODO -- temporary hack.  We need some specific knowledge fo the implementation
        // in order to edit it,  but do it without a cast
        colorScale = (ContinuousColorScale) PreferenceManager.getInstance().getDefaultColorScale(type);
        persistResetPreferences();
        showResetDisplay();
    }

    protected void reloadPreferences() {
        PreferenceManager.getInstance().setColorScale(type, colorScale);
        //ColorScaleFactory.clearCache();
        repaint();
    }

    /**
     * Method description
     *
     */
    public void doUserPreferences() {

        GuiUtilities.invokeOnEventThread(new Runnable() {

            public void run() {

                IGVMainFrame.getInstance().setStatusBarMessage("Setting view properties...");

                HeatmapLegendEditor dialog = new HeatmapLegendEditor(IGVMainFrame.getInstance(),
                                                 true, type, colorScale);

                dialog.setTitle("HeatMap Preferences");
                dialog.setVisible(true);


                if (dialog.isCanceled())
                {
                    IGVMainFrame.getInstance().resetStatusMessage();
                    return;
                }
        // TODO -- temporary hack.  We need some specific knowledge fo the implementation
        // in order to edit it,  but do it without a cast

                colorScale = (ContinuousColorScale) dialog.getColorScheme();
                PreferenceManager.getInstance().setColorScale(type, colorScale);

                try
                {

                    reloadPreferences();

                }
                finally
                {

                    GuiUtilities.invokeOnEventThread(new Runnable() {

                        public void run() {
                            SwingUtilities.getWindowAncestor(HeatmapLegendPanel.this).toFront();
                        }
                    });

                    IGVMainFrame.getInstance().clearImageCacheForTrackPanels();
                    IGVMainFrame.getInstance().resetStatusMessage();
                }
            }
        });
    }

    protected void paintLegend(Graphics g) {

        DecimalFormat formatter = new DecimalFormat("0.0");

        Graphics2D g2D = null;

        try
        {
            g2D = (Graphics2D) g.create();

            g2D.setFont(FontManager.getScalableFont(10));

            int npts = 5;
            double max = colorScale.getPosEnd();
            double min = colorScale.getNegEnd();

            int w = getWidth() - 20;
            double dx = ((double) w) / npts;
            double dxj = dx / 10;
            double delta = (max - min) / npts;
            double deltaj = delta / 10;

            for (int i = 0; i < npts + 1; i++)
            {
                for (int j = i * 10; j < i * 10 + 10; j++)
                {
                    double val = min + j * deltaj;

                    Color c = colorScale.getColor((float) val);

                    g2D.setColor(c);

                    int x0 = (int) (j * dxj);
                    int x1 = (int) ((j + 1) * dxj);

                    g2D.fillRect(x0, 0, (x1 - x0), (int) (getHeight() / 2));
                }

                double labelVal = min + i * delta;
                int x0 = (int) (i * dx);

                g2D.setColor(Color.BLACK);
                g2D.drawString(formatter.format(labelVal), x0, (int) getHeight() - 5);
            }


        }
        finally
        {
            g2D.dispose();
        }
    }
}
