/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.legend;

//~--- non-JDK imports --------------------------------------------------------
import java.awt.Color;
import java.awt.Dimension;
import org.broad.igv.ui.*;

import java.awt.Graphics;

import javax.swing.JPanel;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.util.ChromosomeColors;

/**
 *
 * @author jrobinso
 */

public class ChromosomeColorLegend extends JPanel {

    
    public ChromosomeColorLegend() {
        this.setSize(480, 24);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(480, 24);
    }
    
    
    
    /**
     * Method description
     *
     *
     * @param g
     */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        paintLegend(g);
    }

    
    public void paintLegend(Graphics g) {

        Graphics textGraphics = g.create();
        textGraphics.setColor(Color.black);
        textGraphics.setFont(FontManager.getScalableFont(10));
 
        int w = (int) (getWidth() / 24);
        int h = getHeight() / 2;
        int x = 0;
        
        for(int i=1; i<=24; i++) {
            String chr = (i < 23 ? "chr" + i : i == 23 ? "chrX" : "chrY");
            Color c = ChromosomeColors.getColor(chr);
            g.setColor(c);
            g.fillRect(x, 0, w, h);
            
            String tmp = (i < 23 ? String.valueOf(i) : i == 23 ? "X" : "Y");
            GraphicUtils.drawCenteredText( tmp, x, h, w, h, textGraphics);
            x += w;
                
        }
        
        
    }
}
