/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.event;

import java.awt.KeyEventDispatcher;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.GeneTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackManager;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.IGVModel;
import org.broad.igv.ui.ViewContext;

/**
 *
 * @author jrobinso
 */
public class GlobalKeyDispatcher implements KeyEventDispatcher {

    private final InputMap keyStrokes = new InputMap();
    private final ActionMap actions = new ActionMap();

    public GlobalKeyDispatcher() {
        init();
    }

    public InputMap getInputMap() {
        return keyStrokes;
    }

    public ActionMap getActionMap() {
        return actions;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {

        if (event.getKeyCode() == KeyEvent.VK_ESCAPE) {
            TrackManager.getInstance().clearTrackSelections();
            IGVMainFrame.getInstance().repaint();
            return true;
        }

        KeyStroke ks = KeyStroke.getKeyStrokeForEvent((KeyEvent) event);
        String actionKey = (String) keyStrokes.get(ks);


        // Disable tooltip if control key is pressed
        if (event.getKeyCode() == KeyEvent.VK_CONTROL) {
            boolean flag = !event.isControlDown();
            ToolTipManager.sharedInstance().setEnabled(flag);
        }

        if (actionKey != null) {

            Action action = actions.get(actionKey);
            if (action != null && action.isEnabled()) {
                // I'm not sure about the parameters
                action.actionPerformed(
                        new ActionEvent(event.getSource(), event.getID(),
                        actionKey, ((KeyEvent) event).getModifiers()));
                return true; // consume event
            }
        }

        return false;
    }

    // Here for convenience,  move out of this class eventually
    public void init() {

        final KeyStroke nextKey = KeyStroke.getKeyStroke(KeyEvent.VK_F, KeyEvent.CTRL_MASK, false);
        final KeyStroke prevKey = KeyStroke.getKeyStroke(KeyEvent.VK_B, KeyEvent.CTRL_MASK, false);
        final KeyStroke toolsKey = KeyStroke.getKeyStroke(KeyEvent.VK_T, KeyEvent.ALT_MASK, false);


        final Action toolAction = new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                setEnabled(false); // stop any other events from interfering
                IGVMainFrame.getInstance().enableToolMenu();
                setEnabled(true);
            }
        };

        final Action nextAction = new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                setEnabled(false); // stop any other events from interfering
                nextFeature(true);
                setEnabled(true);
            }
        };
        final Action prevAction = new AbstractAction() {

            public void actionPerformed(ActionEvent e) {
                setEnabled(false); // stop any other events from interfering
                nextFeature(false);
                setEnabled(true);
            }
        };

        getInputMap().put(nextKey, "nextFeature");
        getActionMap().put("nextFeature", nextAction);
        getInputMap().put(prevKey, "prevFeature");
        getActionMap().put("prevFeature", prevAction);
        getInputMap().put(toolsKey, "tools");
        getActionMap().put("tools", toolAction);

    }

    private void nextFeature(boolean forward) {
        ViewContext vc = getViewContext();
        Collection<Track> tracks = TrackManager.getInstance().getSelectedTracks();
        if (tracks.size() == 1) {
            Track t = tracks.iterator().next();
            if (!(t instanceof FeatureTrack || t instanceof GeneTrack)) {
                JOptionPane.showMessageDialog(IGVMainFrame.getInstance(),
                        "Track panning is not enabled for data tracks.");

                return;
            }

            LocusScore f = null;

            String chr = getViewContext().getChrName();
            List<Feature> features = getFeatures(t, chr);
            double center = getViewContext().getCenter();

            boolean canScroll = (forward && !vc.windowAtEnd()) ||
                    (!forward && vc.getOrigin() > 0);

            if (features != null && features.size() > 0 && canScroll) {
                f = forward ? FeatureUtils.getFeatureAfter(center + 1, features) : FeatureUtils.getFeatureBefore(center - 1, features);
            }
            if (f == null) {
                String nextChr = chr;
                while (f == null && (nextChr = forward ? vc.getNextChrName(nextChr) : vc.getPrevChrName(nextChr)) != null) {
                    List<Feature> fl = getFeatures(t, nextChr);
                    if (fl != null && fl.size() > 0) {
                        int zoom = getViewContext().getZoom();
                        getViewContext().setChromosomeName(nextChr);
                        getViewContext().zoomAndCenter(zoom);
                        f = forward ? fl.get(0) : fl.get(fl.size() - 1);
                    }
                }
            }

            if (f != null) {
                double newCenter = f.getStart();
                getViewContext().centerOnLocation(newCenter);
            }
        } else {
            JOptionPane.showMessageDialog(IGVMainFrame.getInstance(),
                    "To use track panning you must first select a single feature track.");
        }

    }

    // Convenient method to hide some ugliness until refactoring
    private List<Feature> getFeatures(Track track, String chr) {
        if (track instanceof FeatureTrack) {
            return ((FeatureTrack) track).getFeatures(chr);
        } else if (track instanceof GeneTrack) {
            return ((GeneTrack) track).getFeatures(chr);
        } else {
            return null;
        }

    }

    private ViewContext getViewContext() {
        return IGVModel.getInstance().getViewContext();
    }
}
