/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import org.broad.igv.ui.util.SortDialog;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.TrackManager;
import org.broad.igv.ui.GuiUtilities;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.UIConstants;

/**
 *
 * @author jrobinso
 */
public class SortTracksMenuAction extends MenuAction {

    //static Logger log = Logger.getLogger(SortTracksMenuAction.class);
    IGVMainFrame mainFrame;

    public SortTracksMenuAction(String label, int mnemonic, IGVMainFrame mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        setToolTipText(UIConstants.SORT_TRACKS_TOOLTIP);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GuiUtilities.invokeOnEventThread(new Runnable() {

            public void run() {
                doSortTrackByAttribute();
            }
        });

    }

    final public void doSortTrackByAttribute() {

        List<String> keys = AttributeManager.getInstance().getAttributeKeys();
        if (keys != null) {
            Collections.sort(keys,
                    AttributeManager.getInstance().getAttributeComparator());
        }
        Object availableSortKeys[] = keys.toArray();
        SortDialog dialog = new SortDialog(mainFrame, true, availableSortKeys);
        dialog.setVisible(true);

        if (dialog.isCanceled()) {
            return;
        }

        String[] selectedSortKeys = dialog.getSelectedSortKeys();
        if (selectedSortKeys != null) {
            TrackManager.getInstance().sortAllTracksByAttributes(
                    selectedSortKeys, dialog.isAscending());
            mainFrame.fireViewChangedEvent();
            mainFrame.repaint();
        }


    }
}
