/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.action;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.math.stat.StatUtils;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackManager;
import org.broad.igv.ui.GuiUtilities;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.UIConstants;

/**
 *
 * @author jrobinso
 */
public class SetOverlayDatasetAction extends MenuAction {

    static Logger log = Logger.getLogger(SetOverlayDatasetAction.class);
    static int lastTrackHeight = -1;
    IGVMainFrame mainFrame;

    public SetOverlayDatasetAction(String label, IGVMainFrame mainFrame) {
        super(label);
        this.mainFrame = mainFrame;
        setToolTipText(UIConstants.SET_DEFAULT_TRACK_HEIGHT_TOOLTIP);
    }

    @Override
    public void actionPerformed(ActionEvent e) {

        GuiUtilities.invokeOnEventThread(new Runnable() {

            public void run() {

                JPanel container = new JPanel();
                JLabel label = new JLabel("Overlay Dataset: ");
                JTextField datasetNameField = new JTextField();
                Dimension preferredSize = datasetNameField.getPreferredSize();
                datasetNameField.setPreferredSize(
                    new Dimension(50, (int) preferredSize.getHeight()));
                container.add(label);
                container.add(datasetNameField);

                datasetNameField.setText(TrackManager.OVERLAY_DATASET);

                int status =
                    JOptionPane.showConfirmDialog(
                    mainFrame,
                    container,
                    "Set Track Height",
                    JOptionPane.OK_CANCEL_OPTION,
                    JOptionPane.PLAIN_MESSAGE,
                    null);

                if (status == JOptionPane.CANCEL_OPTION ||
                    status == JOptionPane.CLOSED_OPTION) {
                    return;
                }

                try {
                    TrackManager.OVERLAY_DATASET = datasetNameField.getText().trim();
                    mainFrame.updateTrackState();
                } catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(mainFrame, "Track height must be an integer number.");
                }


            }
        });
    }

    /**
     * Return a representative track height to use as the default.  For now
     * using the median track height.  
     * @return
     */
    private int getRepresentativeTrackHeight() {

        if (lastTrackHeight > 0) {
            return lastTrackHeight;
        }

        // Get all tracks except the gene track
        List<Track> tracks = TrackManager.getInstance().getAllTracks(false);



        double[] heights = new double[tracks.size()];
        for (int i = 0; i < tracks.size(); i++) {
            heights[i] = tracks.get(i).getHeight();
        }
        int medianTrackHeight = (int) Math.round(StatUtils.percentile(heights, 50));
        if (medianTrackHeight > 0) {
            return medianTrackHeight;
        }

        return PreferenceManager.getInstance().getDefaultTrackHeight();

    }
}
