/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.action;

//~--- non-JDK imports --------------------------------------------------------
import org.apache.log4j.Logger;

import org.broad.igv.IGVConstants;
import org.broad.igv.PreferenceManager;
import org.broad.igv.session.Session;
import org.broad.igv.session.SessionManager;
import org.broad.igv.ui.util.FileChooserDialog;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.WaitCursorManager.CursorToken;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.IGVModel;
import org.broad.igv.ui.LongRunningTask;
import org.broad.igv.ui.UIConstants;

//~--- JDK imports ------------------------------------------------------------

import java.awt.event.ActionEvent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.broad.igv.session.SessionWriter;

/**
 *
 * @author jrobinso
 */
public class SaveSessionMenuAction extends MenuAction {

    static Logger log = Logger.getLogger(SaveSessionMenuAction.class);

    // TODO -- The main frame is likely to be used by many actions. Move this
    // member to a base class ?
    IGVMainFrame mainFrame;

    /**
     * Constructs ...
     *
     *
     * @param label
     * @param mnemonic
     * @param mainFrame
     */
    public SaveSessionMenuAction(String label, int mnemonic, IGVMainFrame mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        setToolTipText(UIConstants.SAVE_SESSION_TOOLTIP);
    }

    /**
     * Method description
     *
     *
     * @param e
     */
    @Override
    public void actionPerformed(ActionEvent e) {


        File sessionFile = null;
        FileChooserDialog dialog = null;

        String currentSessionFilePath = mainFrame.getCurrentSessionFilePath();

        // If no previous session file or we're doing a save as
        if (true) // currentSessionFilePath == null)
        {

            dialog = new FileChooserDialog(mainFrame, true);
            dialog.setTitle("Save Session");
            dialog.setFileSelectionMode(JFileChooser.FILES_ONLY);

            if (currentSessionFilePath == null)
            {
                dialog.setSelectedFile(null);
            } else
            {
                File currentSession = new File(currentSessionFilePath);
                dialog.setSelectedFile(currentSession);
            }

            if (dialog.getSelectedFile() == null)
            {
                dialog.setSelectedFile(new File(IGVConstants.DEFAULT_SESSION_FILE));
            }

            dialog.setCurrentDirectory(PreferenceManager.getInstance().getLastSessionDirectory());

            dialog.setVisible(true);

            if (dialog.isCanceled())
            {
                mainFrame.resetStatusMessage();
                return;
            }

            File file = dialog.getSelectedFile();
            if (file == null)
            {
                log.error("Failed to save session!");
                return;
            }
            sessionFile = file;

            String filePath = file.getAbsolutePath();
            if (filePath.toLowerCase().endsWith(IGVConstants.SESSION_FILE_EXTENSION))
            {    // Its ok
                sessionFile = file;
            } else
            {
                sessionFile = new File(filePath + IGVConstants.SESSION_FILE_EXTENSION);
            }

        } else
        {
            sessionFile = new File(currentSessionFilePath);
        }

        mainFrame.setStatusBarMessage("Saving session to " + sessionFile.getAbsolutePath());

        // Get rid of old file before creating the new one
        if (sessionFile.exists())
        {
            sessionFile.delete();
        }


        final File sf = sessionFile;
        LongRunningTask.submit(new Runnable() {

            public void run() {
                FileOutputStream out = null;
                try
                {

                    Session session = new Session(sf.getAbsolutePath());
                    session.setLocus(
                        IGVModel.getInstance().getViewContext().getCurrentLocusString());
                    session.setFilter(IGVMainFrame.getInstance().getTrackFilter());
                    (new SessionWriter()).saveSession(session, sf);

                    mainFrame.setCurrentSessionFilePath(sf.getAbsolutePath());

                    // No errors so save last location
                    PreferenceManager.getInstance().setLastSessionDirectory(sf.getParentFile());

                } catch (Exception e)
                {
                    JOptionPane.showMessageDialog(mainFrame, "There was an error writing to " + sf.getName() + "(" + e.getMessage() + ")");
                    log.error("Failed to save session!", e);
                } finally
                {

                    mainFrame.resetStatusMessage();

                    if (out != null)
                    {

                        try
                        {
                            out.close();
                        } catch (IOException exception)
                        {
                            log.error("Failed to close session file!", exception);
                        }
                    }
                }
            }
        });

    }
}
