/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/



/*
* To change this template, choose Tools | Templates
* and open the template in the editor.
 */
package org.broad.igv.ui.action;

//~--- non-JDK imports --------------------------------------------------------

import org.apache.log4j.Logger;

import org.broad.igv.feature.GenomeManager;
import org.broad.igv.feature.GenomeManager.GenomeListItem;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.UserDefinedGenomeCheckList;

//~--- JDK imports ------------------------------------------------------------

import java.awt.event.ActionEvent;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

import javax.swing.JOptionPane;
import org.broad.igv.ui.GuiUtilities;

/**
 *
 * @author eflakes
 */
public class RemoveUserDefinedGenomeMenuAction extends MenuAction {

    static Logger logger = Logger.getLogger(RemoveUserDefinedGenomeMenuAction.class);

    /**
     * Constructs ...
     *
     *
     * @param label
     * @param mnemonic
     */
    public RemoveUserDefinedGenomeMenuAction(String label, int mnemonic) {
        super(label, null, mnemonic);
        setToolTipText(UIConstants.REMOVE_USER_DEFINE_GENOME_TOOLTIP);
    }

    /**
     * Method description
     *
     *
     * @param e
     */
    @Override
    public void actionPerformed(ActionEvent e) {

        GuiUtilities.invokeOnEventThread(new Runnable() {
            public void run() {
                removeGenome();
            }
        });
    }

    private void removeGenome() {

        try
        {

            LinkedHashSet<GenomeListItem> genomeItemList =
                GenomeManager.getInstance().getUserDefinedGenomeArchiveList(null);

            if (genomeItemList.isEmpty())
            {
                JOptionPane.showMessageDialog(IGVMainFrame.getInstance(),
                                              "There are no imported genomes to remove.");
            }
            else
            {

                GenomeListItem currentlySelectedDropdownGenome = 
                    IGVMainFrame.getInstance().getGenomeSelectedInDropdown();
                List<String> genomeNames = new ArrayList();
                UserDefinedGenomeCheckList checkList = new UserDefinedGenomeCheckList(false);
                for (GenomeListItem genomeListItem : genomeItemList)
                {
                    genomeNames.add(genomeListItem.getDisplayableName());
                }
                checkList.addItems(genomeNames);
                checkList.sort();
                int status = JOptionPane.showConfirmDialog(IGVMainFrame.getInstance(), checkList,
                                 "Imported Genomes to Remove", JOptionPane.OK_CANCEL_OPTION,
                                 JOptionPane.PLAIN_MESSAGE, null);

                if ((status == JOptionPane.CANCEL_OPTION) || (status == JOptionPane.CLOSED_OPTION))
                {
                    return;
                }

                boolean removed = false;
                HashSet<String> selectedGenomes = checkList.getSelectedGenomes();
                Iterator iterator = genomeItemList.iterator();
                while (iterator.hasNext())
                {
                    String genomeName = ((GenomeListItem) iterator.next()).getDisplayableName();
                    
                    // Skip genome if not selected for removal
                    if(!selectedGenomes.contains(genomeName)) {
                        continue;
                    }
                    
                    if(currentlySelectedDropdownGenome.getDisplayableName().equalsIgnoreCase(genomeName)) {
                        JOptionPane.showMessageDialog(
                            IGVMainFrame.getInstance(), 
                            "<html>Genome ["+genomeName+"] is currently in use and cannot be removed."+
                            "<br>Please select another genome to view before trying to remove it.</html>");
                        continue;
                    }
                    
                    if (selectedGenomes.contains(genomeName))
                    {
                        iterator.remove();
                        removed = true;
                    }
                }
                
                if(removed) {
                    GenomeManager.getInstance().rebuildClientGenomeList(genomeItemList);
                    IGVMainFrame.getInstance().rebuildGenomeDropdownList(null);
                }
            }
        }
        catch (Exception e)
        {
            JOptionPane.showMessageDialog(IGVMainFrame.getInstance(),
                                          "Error encontered while removing genomes: "
                                          + e.getMessage());
            logger.error("Error removing genomes from the imported genome list.", e);
        }
    }

}
