/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.broad.igv.IGVConstants;
import org.broad.igv.PreferenceManager;
import org.broad.igv.ui.util.FileChooserDialog;
import org.broad.igv.track.TrackManager;
import org.broad.igv.ui.GuiUtilities;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.UIConstants;

/**
 * This menu action classes is used for both "Open Session ..." and load recent
 * session menu items.  In the "Open Session..." the user has to specify a
 * session file through the file menu.  For "load recent"  the action is
 * instantiated with a specific session file.  
 * 
 * @author jrobinso
 */
public class OpenSessionMenuAction extends MenuAction {

    IGVMainFrame mainFrame;

    File sessionFile = null;

    public OpenSessionMenuAction(String label, File sessionFile,  IGVMainFrame mainFrame) {
        super(label);
        this.sessionFile = sessionFile;
        this.mainFrame = mainFrame;
        setToolTipText(UIConstants.RESTORE_SESSION_TOOLTIP);
    }

    public OpenSessionMenuAction(String label, int mnemonic, IGVMainFrame mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        setToolTipText(UIConstants.RESTORE_SESSION_TOOLTIP);
    }

    @Override
    public void actionPerformed(ActionEvent e) {

        GuiUtilities.invokeOnEventThread(new Runnable() {

            public void run() {
                doRestoreSession();
            }
        });
    }

    final public void doRestoreSession() {

        // If anything has been loaded warn the users.  Popping up the
        // warning all the time will get annoying.
        if (TrackManager.getInstance().getAllTracks(false).size() > 0) {
            int status =
                    JOptionPane.showConfirmDialog(
                    mainFrame,
                    IGVConstants.OVERWRITE_SESSION_MESSAGE,
                    null,
                    JOptionPane.OK_CANCEL_OPTION,
                    JOptionPane.PLAIN_MESSAGE,
                    null);

            if (status == JOptionPane.CANCEL_OPTION ||
                    status == JOptionPane.CLOSED_OPTION) {
                return;
            }
        }

        if (sessionFile != null) {
            mainFrame.doRestoreSession(sessionFile, null);
        } else {
            FileChooserDialog dialog = new FileChooserDialog(mainFrame, true);
            dialog.setTitle("Open Session");
            dialog.setSelectedFile(null);
            dialog.setFileSelectionMode(JFileChooser.FILES_ONLY);

            File lastSessionDirectory =
                    PreferenceManager.getInstance().getLastSessionDirectory();
            dialog.setCurrentDirectory(lastSessionDirectory);
            dialog.setVisible(true);

            if (dialog.isCanceled()) {
                return;
            }
            mainFrame.doRestoreSession(dialog.getSelectedFile(), null);
        }

    }
}
