/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.broad.igv.IGVConstants;
import org.broad.igv.track.TrackManager;
import org.broad.igv.ui.GuiUtilities;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.UIConstants;

/**
 *
 * @author jrobinso
 */
public class NewSessionMenuAction extends MenuAction {

    IGVMainFrame mainFrame;

    public NewSessionMenuAction(String label, int mnemonic, IGVMainFrame mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        setToolTipText(UIConstants.NEW_SESSION_TOOLTIP);
    }

    @Override
    public void actionPerformed(ActionEvent e) {

        GuiUtilities.invokeOnEventThread(new Runnable() {

            public void run() {
                try {
                    if (TrackManager.getInstance().getAllTracks(false).size() > 0) {
                        int status =
                                JOptionPane.showConfirmDialog(
                                mainFrame,
                                IGVConstants.NEW_SESSION_MESSAGE,
                                null,
                                JOptionPane.OK_CANCEL_OPTION,
                                JOptionPane.PLAIN_MESSAGE,
                                null);

                        if (status == JOptionPane.CANCEL_OPTION ||
                                status == JOptionPane.CLOSED_OPTION) {
                            return;
                        }
                    }
                    mainFrame.reset(false); // Clear everything but the genome
                    mainFrame.doRefresh();
                } finally {
                }
            }
        });
    }
}
