/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import org.apache.log4j.Logger;
import org.broad.igv.IGVConstants;
import org.broad.igv.PreferenceManager;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.ui.util.FileChooserDialog;
import org.broad.igv.ui.GuiUtilities;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.UIConstants;

/**
 *
 * @author jrobinso
 */
public class LoadFilesMenuAction extends MenuAction {

    static Logger log = Logger.getLogger(LoadFilesMenuAction.class);
    IGVMainFrame mainFrame;

    public LoadFilesMenuAction(String label, int mnemonic, IGVMainFrame mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        setToolTipText(UIConstants.LOAD_TRACKS_TOOLTIP);
    }

    @Override
    public void actionPerformed(ActionEvent e) {

        GuiUtilities.invokeOnEventThread(new Runnable() {

            public void run() {
                loadFiles(chooseTrackFiles());
            }
        });
    }

    private File[] chooseTrackFiles() {

        File lastDirectoryFile =
                PreferenceManager.getInstance().getLastTrackDirectory();

        // Get Track Files
        FileChooserDialog trackFileDialog = mainFrame.getTrackFileChooser();
        trackFileDialog.setLocationRelativeTo(mainFrame);
        trackFileDialog.setTitle("Select Files");
        trackFileDialog.setMultiSelectionEnabled(true);
        trackFileDialog.setSelectedFile(null);
        trackFileDialog.setCurrentDirectory(lastDirectoryFile);
        trackFileDialog.setFileSelectionMode(JFileChooser.FILES_ONLY);


        trackFileDialog.setVisible(true);

        // Tracks.  Simulates multi-file select
        File[] trackFiles = null;

        if (!trackFileDialog.isCanceled()) {

            File lastFile = trackFileDialog.getSelectedFile();
            if (lastFile != null && !lastFile.isDirectory()) {
                lastFile = lastFile.getParentFile();

                // Store the last accessed file location
                PreferenceManager.getInstance().setLastTrackDirectory(lastFile);
            }

            trackFiles = trackFileDialog.getSelectedFiles();
            trackFileDialog.setSelectedFile(null);
        }

        mainFrame.resetStatusMessage();

        return trackFiles;
    }

    private void loadFiles(File[] files) {

        if (files != null && files.length > 0) {

            List<File> validFileList = new ArrayList();
            StringBuffer buffer = new StringBuffer();
            buffer.append("File(s) not found: ");
            boolean allFilesExist = true;
            for (File file : files) {

                if (!file.exists()) {
                    allFilesExist = false;
                    buffer.append("\n\t");
                    buffer.append(file.getAbsolutePath());
                } else {

                    String path = file.getAbsolutePath();
                    if (path.endsWith(IGVConstants.SESSION_FILE_EXTENSION)) {
                        org.broad.igv.ui.util.UIUtilities.showAndLogErrorMessage(mainFrame,
                                "File " + path +
                                " appears to be an IGV Session file - " +
                                "please use the Open Session menu item " +
                                "to load it.", log);
                    } else {
                        validFileList.add(file);
                    }
                }

            }
            files = validFileList.toArray(new File[validFileList.size()]);

            if (!allFilesExist) {
                org.broad.igv.ui.util.UIUtilities.showAndLogErrorMessage(mainFrame, buffer.toString(), log);
            }

            if (files.length > 0) {

                // Create DataResouceLocators for the selected files
                final List<ResourceLocator> locators =
                        new ArrayList(files.length);
                for (File f : files) {
                    locators.add(new ResourceLocator(f.getAbsolutePath()));
                }

                mainFrame.loadTracks(locators);
            }
        }
    }
}
