/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JDialog;
import org.broad.igv.PreferenceManager;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.TrackManager;
import org.broad.igv.ui.AttributeSelectionDialog;
import org.broad.igv.ui.GuiUtilities;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.UIConstants;

/**
 *
 * @author jrobinso
 */
public class GroupTracksMenuAction extends MenuAction {

    //static Logger log = Logger.getLogger(GroupTracksMenuAction.class);
    IGVMainFrame mainFrame;

    public GroupTracksMenuAction(String label, int mnemonic, IGVMainFrame mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        setToolTipText(UIConstants.GROUP_TRACKS_TOOLTIP);
    }

    @Override
    public void actionPerformed(ActionEvent e) {

        GuiUtilities.invokeOnEventThread(new Runnable() {

            public void run() {
                doGroupBy();
            }
        });

    }

    final public void doGroupBy() {

        final AttributeSelectionDialog dlg = new AttributeSelectionDialog(mainFrame, true);

        List<String> attributeKeys =
                AttributeManager.getInstance().getAttributeKeys();
        if (attributeKeys != null) {
            Collections.sort(attributeKeys,
                    AttributeManager.getInstance().getAttributeComparator());
        }

        ArrayList<String> selections = new ArrayList(attributeKeys);
        
        selections.add(0, "None");
        String[] selArray = selections.toArray(new String[]{});

        dlg.setModel(new javax.swing.DefaultComboBoxModel(selArray));
        dlg.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);

        String currentSelection = TrackManager.getInstance().getGroupByAttribute();
        if (currentSelection == null) {
            dlg.setSelectedIndex(0);
        } else {
            dlg.setSelectedItem(currentSelection);
        }

        dlg.setVisible(true);

        if (!dlg.isCanceled()) {

            int selIndex = dlg.getSelectedIndex();
            String selectedAttribute = (selIndex == 0 ? null : selArray[selIndex]);
            TrackManager.getInstance().setGroupByAttribute(selectedAttribute);
            mainFrame.updateTrackState();
            mainFrame.doRefresh();
            mainFrame.fireViewChangedEvent();

            //boolean isEnabled = PreferenceManager.getInstance().isImageCachingEnabled();
            //mainFrame.setDisableImageCaching(isEnabled);
        }

    }
}
