/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;
import org.broad.igv.ui.GuiUtilities;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.UIConstants;

/**
 *
 * @author jrobinso
 */
public class ExportRegionsMenuAction extends RegionsBaseMenuAction {

    static Logger log = Logger.getLogger(ExportRegionsMenuAction.class);

    public ExportRegionsMenuAction(String label, int mnemonic, IGVMainFrame mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        setToolTipText(UIConstants.EXPORT_REGION_TOOLTIP);
    }

    @Override
    public void actionPerformed(ActionEvent e) {

        GuiUtilities.invokeOnEventThread(new Runnable() {

            public void run() {
                importExportRegionsOfInterest(Direction.EXPORT);
            }
        });
    }
}
