/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import org.broad.igv.PreferenceManager;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.UIConstants;

/**
 *
 * @author jrobinso
 */
public class DisableDirectDrawAction extends MenuAction {

    IGVMainFrame mainFrame;

    public DisableDirectDrawAction(String label, int mnemonic, IGVMainFrame mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        setToolTipText(UIConstants.MACRO_SNAPSHOTS);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem) e.getSource();

        boolean isSelected = menuItem.getState();
        PreferenceManager.getInstance().setDirectDrawDisabled(isSelected);

        org.broad.igv.ui.util.UIUtilities.showConfirmationDialog(
                mainFrame,
                "Requires a restart of IGV to take effect!");
        setToolTipText(UIConstants.DIRECT_DRAW_DISABLED_TOOLTIP);

    }
}
