/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/



/*
* To change this template, choose Tools | Templates
* and open the template in the editor.
 */
package org.broad.igv.ui.action;

//~--- non-JDK imports --------------------------------------------------------

import org.apache.log4j.Logger;

import org.broad.igv.feature.GenomeManager;
import org.broad.igv.ui.GuiUtilities;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.UIConstants;

import java.awt.event.ActionEvent;


import javax.swing.JOptionPane;
import org.broad.igv.ui.IGVModel;

/**
 *
 * @author eflakes
 */
public class ClearGenomeCacheAction extends MenuAction {

    static Logger logger = Logger.getLogger(ClearGenomeCacheAction.class);

    /**
     * Constructs ...
     *
     *
     * @param label
     */
    public ClearGenomeCacheAction(String label) {
        super(label, null);
        setToolTipText(UIConstants.CLEAR_GENOME_CACHE_TOOLTIP);
    }

    /**
     * Method description
     *
     *
     *
     * @param evt
     */
    @Override
    public void actionPerformed(ActionEvent evt) {

        try
        {
            int option = (JOptionPane.showConfirmDialog(IGVMainFrame.getInstance(),
                             "Clear the genome cache ?", "Clear the genome cache ?",
                             JOptionPane.YES_NO_OPTION));
            if (option == JOptionPane.YES_OPTION)
            {
                {
                    final String genomeId = IGVModel.getInstance().getViewContext().getGenomeId();
                    GenomeManager.getInstance().clearGenomeCache();
                    GuiUtilities.invokeOnEventThread(new Runnable() {
                        public void run() {
                            IGVMainFrame.getInstance().rebuildGenomeDropdownList(null);
                            IGVMainFrame.getInstance().setGenomeId(genomeId);
                        }
                    });
                }
            }

        }
        catch (Exception e)
        {
            JOptionPane.showMessageDialog(IGVMainFrame.getInstance(),
                                          "Error encontered while removing genomes: "
                                          + e.getMessage());
            logger.error("Error removing genomes from the user-defined genome list.", e);
        }
    }

}
