/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.util.FeatureCountDialog;

/**
 *
 * @author jrobinso
 */
public class BedFileConvertMenuAction extends MenuAction {

    static Logger log = Logger.getLogger(BedFileConvertMenuAction.class);

    // TODO -- The main frame is likely to be used by many actions. Move this
    // member to a base class ?
    IGVMainFrame mainFrame;

    public BedFileConvertMenuAction(String label, IGVMainFrame mainFrame) {
        super(label);
        this.mainFrame = mainFrame;
        setToolTipText("Convert a bed file to an igv count density file.");
    }

    @Override
    public void actionPerformed(ActionEvent e) {

      
        FeatureCountDialog dialog = null;

        dialog = new FeatureCountDialog(IGVMainFrame.getInstance(), true);
        

        dialog.setVisible(true);


    }
}
