/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */

/*
 * ZoomSliderPanel.java
 *
 * Created on September 25, 2007, 12:03 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package org.broad.igv.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.broad.igv.ui.util.IconFactory;
import org.broad.igv.ui.WaitCursorManager.CursorToken;

/**
 *
 * @author jrobinso
 */
public class ZoomSliderPanel extends JPanel {
    
    static Color TICK_GRAY = new Color(90, 90, 90);
    static Color TICK_BLUE = new Color(25, 50, 200);

    public static ZoomSliderPanel theInstance;
    //double imageScaleFactor = 0.8;
    Image slider;
    Image zoomPlus;
    Image zoomMinus;
    Rectangle zoomPlusRect;
    Rectangle zoomMinusRect;
    Rectangle[] zoomLevelRects;
    /**
     * Should correspond to "maxZoomLevel" in class viewContext.
     */
    int numZoomLevels = 25;

    /** Creates a new instance of ZoomSliderPanel */
    public ZoomSliderPanel() {
        theInstance = this;
        slider = IconFactory.getInstance().getIcon(IconFactory.IconID.SLIDER).getImage();
        zoomPlus = IconFactory.getInstance().getIcon(IconFactory.IconID.ZOOM_PLUS).getImage();
        zoomMinus = IconFactory.getInstance().getIcon(IconFactory.IconID.ZOOM_MINUS).getImage();
        zoomLevelRects = new Rectangle[numZoomLevels];

        setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));

        init();
    }

    private void updateTickCount() {
        int tmp = getViewContext().getMaxZoom() + 1;
        if (tmp != numZoomLevels)
        {
            numZoomLevels = tmp;
            zoomLevelRects = new Rectangle[numZoomLevels];
        }

    }


    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        updateTickCount();
        if (this.isEnabled())
        {
            paintHorizontal(g);
        }

    }

    protected void paintHorizontal(Graphics g) {

        int buttonWidth = zoomPlus.getWidth(null);
        int buttonHeight = zoomPlus.getHeight(null);

        Insets insets = getInsets();
        int panelWidth = getWidth() - insets.left - insets.right;
        int panelHeight = getHeight() - insets.top - insets.bottom;


        g.setColor(isEnabled() ? Color.BLACK : Color.LIGHT_GRAY);
        double x = insets.left;

        double xStep = ((double) (panelWidth  - 2 * buttonWidth - 10)) / (numZoomLevels);
 
        int y = insets.top + (panelHeight - buttonHeight) / 2;
        if (isEnabled())
        {
            g.drawImage(zoomMinus, (int) x, y, null);
        }
        zoomMinusRect = new Rectangle((int) x, y, buttonWidth, buttonHeight);

        x += 5 + buttonWidth;

        int lastX = (int) (x - xStep);
        for (int i = 0; i < numZoomLevels; i++)
        {
            Rectangle zoomRect = new Rectangle((int) x, y, (int)(x - lastX), buttonHeight);
            int xLine = (int) (x + xStep / 2);
            g.drawLine(xLine, y + 3, xLine, y + buttonHeight - 4);
            zoomLevelRects[i] = zoomRect;
            lastX = (int) x;
            x += xStep;
        }

        x += 5;

        y = insets.top + panelHeight / 2 - 1;
        //g.drawLine(xTop, y, xBottom, y);

        y = insets.top + (panelHeight - buttonHeight) / 2;
        if (isEnabled())
        {
            g.drawImage(zoomPlus, (int) x, y, null);
        }
        zoomPlusRect = new Rectangle((int) x, y, buttonWidth, buttonWidth);

        // Draw current level -- zoomIndex is the zoom level + 1. 

        int zoom = (toolZoom >= 0 ? toolZoom : getViewContext().getAdjustedZoom());
        if (zoom >= 0 && zoom < zoomLevelRects.length)
        {
            Rectangle rect = zoomLevelRects[zoom];
            
            g.setColor(TICK_BLUE);
            ((Graphics2D) g).fill3DRect(
                (int) (rect.getX() + rect.getWidth() / 2) - 3, 
                (int) rect.getY(),
                6, 
                (int) rect.getHeight(), 
                true);

        //y =  (int) (rect.getY() + (rect.getHeight() - slider.getHeight(null)) / 2);
        // temporary hack
        //if(zoomIndex == 12) y += 15;
        //g.drawImage(slider, x + 1, y, null);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        setVisible(isEnabled);
    }

    void setZoom(MouseEvent e) {

        if (zoomPlusRect.contains(e.getX(), e.getY()))
        {
            toolZoom++;
        } else if (zoomMinusRect.contains(e.getX(), e.getY()))
        {
            toolZoom--;
        } else
        {
            for (int i = 0; i < zoomLevelRects.length; i++)
            {
                Rectangle rect = zoomLevelRects[i];
                if (rect.contains(e.getX(), e.getY()))
                {
                    toolZoom = i;
                }
            }
        }
    }

    // TODO implement without reference to the frame singleton
    private ViewContext getViewContext() {
        return IGVModel.getInstance().getViewContext();
    }
    int toolZoom = -1;

    private void init() {

        MouseInputAdapter mouseAdapter = new MouseInputAdapter() {

            int lastMousePressX = 0;

            @Override
            public void mouseExited(MouseEvent e) {

            }

            @Override
            public void mouseClicked(MouseEvent e) {

            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                toolZoom = Math.max(0, getViewContext().getAdjustedZoom());
            }

            @Override
            public void mouseReleased(MouseEvent e) {

                setZoom(e);
                repaint();

                LongRunningTask.submit(new Runnable() {
                    public void run() {
                            getViewContext().zoomAndCenterAdjusted(toolZoom);
                            toolZoom = -1;
                    }
                });
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                // Dragging zoom tool is disable.  Generates too many
                // repaint events.
                setZoom(e);
                repaint();
            }
        };

        addMouseMotionListener(mouseAdapter);
        addMouseListener(mouseAdapter);
    }
}
