/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.broad.igv.ui;

import java.awt.Component;
import java.util.List;
import org.broad.igv.util.Filter;
import org.broad.igv.util.FilterElement;
import org.broad.igv.ui.util.FilterComponent;
import org.broad.igv.ui.util.FilterPane;
import org.broad.igv.track.Track;

/**
 *
 * @author eflakes
 */
public class TrackFilterPane extends FilterPane {

    private boolean matchAll = true;

    public TrackFilterPane(List<String> items, String itemListLabel, TrackFilter filter) {
        super(items, itemListLabel, filter);
    }    
    
    public Filter createNewFilter() {
        String name = "";        
        return new TrackFilter(name, null);
    }
    
    @Override
    public TrackFilter getFilter() {
        return (TrackFilter)super.getFilter();
    }
    
    public void clearTracks() {
        ((TrackFilter)getFilter()).clearTracks();
    }
    
    public void addTracks(List<Track> tracks) {
        ((TrackFilter)getFilter()).addTracks(tracks);
    }
    
    public  FilterComponent createFilterComponent(FilterPane filterPane, 
            String itemListLabel, List<String> itemList, FilterElement element) {
        
        return new TrackFilterComponent((TrackFilterPane)filterPane, itemListLabel, itemList, element);
    }

    public void setMatchAll(boolean value)
    {
        matchAll = value;
    }

    public boolean getMatchAll()
    {
        return matchAll;
    }

    public void applyFilterMatching() {
        Component[] filterComponents = getComponents();
        for(Component filterComponent : filterComponents) {
            ((TrackFilterComponent)filterComponent).setMatchAll(matchAll);
        }
    }
        
    /**
     * Only for use with more() method.
     */
    public void addDefaultFilterComponent() {
        
        if(itemListLabel == null) {
            itemListLabel = "When";
        }
        add( new TrackFilterComponent(this, itemListLabel, itemList, null) );
    }
    
}
